/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.servlet.ServletException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.restlet.Server;
import org.restlet.engine.adapter.HttpServerHelper;
import org.restlet.ext.jetty.internal.JettyServerCall;

public abstract class JettyServerHelper
extends HttpServerHelper {
    private volatile org.eclipse.jetty.server.Server wrappedServer;

    public JettyServerHelper(Server server) {
        super(server);
    }

    private HttpConfiguration createConfiguration() {
        HttpConfiguration configuration = new HttpConfiguration();
        configuration.setHeaderCacheSize(this.getHttpHeaderCacheSize());
        configuration.setRequestHeaderSize(this.getHttpRequestHeaderSize());
        configuration.setResponseHeaderSize(this.getHttpResponseHeaderSize());
        configuration.setOutputBufferSize(this.getHttpOutputBufferSize());
        configuration.setSendDateHeader(false);
        return configuration;
    }

    protected abstract ConnectionFactory[] createConnectionFactories(HttpConfiguration var1);

    private Connector createConnector(org.eclipse.jetty.server.Server server) {
        HttpConfiguration configuration = this.createConfiguration();
        ConnectionFactory[] connectionFactories = this.createConnectionFactories(configuration);
        int acceptors = this.getConnectorAcceptors();
        int selectors = this.getConnectorSelectors();
        Executor executor = this.getConnectorExecutor();
        Scheduler scheduler = this.getConnectorScheduler();
        ByteBufferPool byteBufferPool = this.getConnectorByteBufferPool();
        ServerConnector connector = new ServerConnector(server, executor, scheduler, byteBufferPool, acceptors, selectors, connectionFactories);
        String address = ((Server)this.getHelped()).getAddress();
        if (address != null) {
            connector.setHost(address);
        }
        connector.setPort(((Server)this.getHelped()).getPort());
        connector.setAcceptQueueSize(this.getConnectorAcceptQueueSize());
        connector.setIdleTimeout((long)this.getConnectorIdleTimeout());
        connector.setSoLingerTime(this.getConnectorSoLingerTime());
        connector.setStopTimeout((long)this.getConnectorStopTimeout());
        return connector;
    }

    private LowResourceMonitor createLowResourceMonitor(org.eclipse.jetty.server.Server server) {
        int period = this.getLowResourceMonitorPeriod();
        if (period > 0) {
            LowResourceMonitor lowResourceMonitor = new LowResourceMonitor(server);
            lowResourceMonitor.setMonitoredConnectors(Arrays.asList(server.getConnectors()));
            lowResourceMonitor.setPeriod(period);
            lowResourceMonitor.setMonitorThreads(this.getLowResourceMonitorThreads());
            lowResourceMonitor.setMaxMemory(this.getLowResourceMonitorMaxMemory());
            lowResourceMonitor.setMaxConnections(this.getLowResourceMonitorMaxConnections());
            lowResourceMonitor.setLowResourcesIdleTimeout(this.getLowResourceMonitorIdleTimeout());
            lowResourceMonitor.setStopTimeout(this.getLowResourceMonitorStopTimeout());
            server.addBean((Object)lowResourceMonitor);
            return lowResourceMonitor;
        }
        return null;
    }

    private org.eclipse.jetty.server.Server createServer() {
        ThreadPool threadPool = this.createThreadPool();
        WrappedServer server = new WrappedServer(this, threadPool);
        Connector connector = this.createConnector(server);
        server.addConnector(connector);
        this.createLowResourceMonitor(server);
        return server;
    }

    private ThreadPool createThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(this.getThreadPoolMinThreads());
        threadPool.setMaxThreads(this.getThreadPoolMaxThreads());
        threadPool.setThreadsPriority(this.getThreadPoolThreadsPriority());
        threadPool.setIdleTimeout(this.getThreadPoolIdleTimeout());
        threadPool.setStopTimeout(this.getThreadPoolStopTimeout());
        return threadPool;
    }

    public int getConnectorAcceptors() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.acceptors", "-1"));
    }

    public int getConnectorAcceptQueueSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.acceptQueueSize", "0"));
    }

    public ByteBufferPool getConnectorByteBufferPool() {
        return null;
    }

    public Executor getConnectorExecutor() {
        return null;
    }

    public int getConnectorIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.idleTimeout", "30000"));
    }

    public Scheduler getConnectorScheduler() {
        return null;
    }

    public int getConnectorSelectors() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.selectors", "-1"));
    }

    public int getConnectorSoLingerTime() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.soLingerTime", "-1"));
    }

    public int getConnectorStopTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("connector.stopTimeout", "30000"));
    }

    public int getHttpHeaderCacheSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.headerCacheSize", "512"));
    }

    public int getHttpOutputBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.outputBufferSize", "32768"));
    }

    public int getHttpRequestHeaderSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.requestHeaderSize", "8192"));
    }

    public int getHttpResponseHeaderSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("http.responseHeaderSize", "8192"));
    }

    public int getLowResourceMonitorIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("lowResource.idleTimeout", "1000"));
    }

    public int getLowResourceMonitorMaxConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("lowResource.maxConnections", "0"));
    }

    public long getLowResourceMonitorMaxMemory() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("lowResource.maxMemory", "0"));
    }

    public int getLowResourceMonitorPeriod() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("lowResource.period", "1000"));
    }

    public long getLowResourceMonitorStopTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("lowResource.stopTimeout", "30000"));
    }

    public boolean getLowResourceMonitorThreads() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("lowResource.threads", "true"));
    }

    public int getThreadPoolIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.idleTimeout", "60000"));
    }

    public int getThreadPoolMaxThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.maxThreads", "200"));
    }

    public int getThreadPoolMinThreads() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.minThreads", "8"));
    }

    public long getThreadPoolStopTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("threadPool.stopTimeout", "5000"));
    }

    public int getThreadPoolThreadsPriority() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("threadPool.threadsPriority", String.valueOf(5)));
    }

    protected org.eclipse.jetty.server.Server getWrappedServer() {
        if (this.wrappedServer == null) {
            this.wrappedServer = this.createServer();
        }
        return this.wrappedServer;
    }

    protected void setWrappedServer(org.eclipse.jetty.server.Server wrappedServer) {
        this.wrappedServer = wrappedServer;
    }

    public void start() throws Exception {
        super.start();
        org.eclipse.jetty.server.Server server = this.getWrappedServer();
        ServerConnector connector = (ServerConnector)server.getConnectors()[0];
        this.getLogger().info("Starting the Jetty " + this.getProtocols() + " server on port " + ((Server)this.getHelped()).getPort());
        server.start();
        this.setEphemeralPort(connector.getLocalPort());
    }

    public void stop() throws Exception {
        this.getLogger().info("Stopping the Jetty " + this.getProtocols() + " server on port " + ((Server)this.getHelped()).getPort());
        this.getWrappedServer().stop();
        super.stop();
    }

    private static class WrappedServer
    extends org.eclipse.jetty.server.Server {
        private final JettyServerHelper helper;

        public WrappedServer(JettyServerHelper server, ThreadPool threadPool) {
            super(threadPool);
            this.helper = server;
        }

        public void handle(HttpChannel channel) throws IOException, ServletException {
            try {
                this.helper.handle(new JettyServerCall((Server)this.helper.getHelped(), channel));
            }
            catch (Throwable e) {
                channel.getEndPoint().close();
                throw new IOException("Exception when closing Jetty HttpChannel", e);
            }
        }

        public void handleAsync(HttpChannel channel) throws IOException, ServletException {
            try {
                this.helper.handle(new JettyServerCall((Server)this.helper.getHelped(), channel));
            }
            catch (Throwable e) {
                channel.getEndPoint().close();
                throw new IOException("Exception when closing Jetty HttpChannel", e);
            }
        }
    }
}

