/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperRepresentation;

public class JsonpRepresentation
extends WrapperRepresentation {
    private final String callback;
    private final Status status;

    public JsonpRepresentation(String callback, Status status, Representation wrappedRepresentation) {
        super(wrappedRepresentation);
        this.callback = callback;
        this.status = status;
    }

    public String getCallback() {
        return this.callback;
    }

    public ReadableByteChannel getChannel() throws IOException {
        return NioUtils.getChannel((InputStream)this.getStream());
    }

    public MediaType getMediaType() {
        return MediaType.APPLICATION_JAVASCRIPT;
    }

    public long getSize() {
        long result = super.getSize();
        if (result > 0L && MediaType.APPLICATION_JSON.equals((Object)super.getMediaType())) {
            return result + (long)this.getCallback().length() + (long)"({status:,body:});".length() + (long)Integer.toString(this.getStatus().getCode()).length();
        }
        return -1L;
    }

    public Status getStatus() {
        return this.status;
    }

    public InputStream getStream() throws IOException {
        return BioUtils.getStream((Representation)this);
    }

    public String getText() throws IOException {
        return BioUtils.toString((InputStream)this.getStream());
    }

    public void write(Writer writer) throws IOException {
        OutputStream os = BioUtils.getStream((Writer)writer, (CharacterSet)this.getCharacterSet());
        this.write(os);
        os.flush();
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getCallback().getBytes());
        outputStream.write("({status:".getBytes());
        outputStream.write(Integer.toString(this.getStatus().getCode()).getBytes());
        outputStream.write(",body:".getBytes());
        if (MediaType.APPLICATION_JSON.equals((Object)super.getMediaType())) {
            BioUtils.copy((InputStream)super.getStream(), (OutputStream)outputStream);
        } else {
            outputStream.write("'".getBytes());
            String text = super.getText();
            if (text.indexOf(39) >= 0) {
                text = text.replace("'", "\\'");
            }
            outputStream.write(text.getBytes());
            outputStream.write("'".getBytes());
        }
        outputStream.write("});".getBytes());
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        OutputStream os = NioUtils.getStream((WritableByteChannel)writableChannel);
        this.write(os);
        os.flush();
    }
}

