/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.way;

import java.io.IOException;
import javax.net.ssl.SSLEngineResult;
import org.restlet.Server;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.connection.SslConnection;
import org.restlet.ext.nio.internal.state.IoState;
import org.restlet.ext.nio.internal.state.MessageState;
import org.restlet.ext.nio.internal.way.HttpServerOutboundWay;

public class HttpsServerOutboundWay
extends HttpServerOutboundWay {
    public HttpsServerOutboundWay(Connection<Server> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    public SslConnection<Server> getConnection() {
        return (SslConnection)super.getConnection();
    }

    @Override
    protected boolean hasIoInterest() {
        return super.hasIoInterest() && (!((SslConnection)this.getConnection()).isSslHandshaking() || ((SslConnection)this.getConnection()).getSslHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
    }

    @Override
    public int preProcess(int maxDrained, Object ... args) throws IOException {
        int result = 0;
        if (this.getIoState() == IoState.READY && this.getMessageState() == MessageState.IDLE) {
            this.getBuffer().beforeDrain();
            result = this.onDrain(this.getBuffer(), maxDrained, args);
        }
        return result;
    }

    @Override
    public void postProcess(int drained) throws IOException {
        ((SslConnection)this.getConnection()).handleSslResult();
    }
}

