/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.simple;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.ext.simple.SimpleServerHelper;
import org.restlet.ext.simple.internal.SimpleContainer;
import org.restlet.ext.simple.internal.SimpleServer;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;

public class HttpServerHelper
extends SimpleServerHelper {
    public HttpServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTP);
    }

    public void start() throws Exception {
        String addr = ((Server)this.getHelped()).getAddress();
        if (addr != null) {
            InetAddress iaddr = InetAddress.getByName(addr);
            this.setAddress(new InetSocketAddress(iaddr, ((Server)this.getHelped()).getPort()));
        } else {
            int port = ((Server)this.getHelped()).getPort();
            if (port > 0) {
                this.setAddress(new InetSocketAddress(((Server)this.getHelped()).getPort()));
            }
        }
        SimpleContainer container = new SimpleContainer(this);
        ContainerServer server = new ContainerServer((Container)container, this.getDefaultThreads());
        SimpleServer restletServer = new SimpleServer((org.simpleframework.transport.Server)server);
        SocketConnection connection = new SocketConnection((org.simpleframework.transport.Server)restletServer);
        this.setConfidential(false);
        this.setContainerServer(server);
        this.setConnection((Connection)connection);
        InetSocketAddress address = (InetSocketAddress)this.getConnection().connect((SocketAddress)this.getAddress());
        this.setEphemeralPort(address.getPort());
        super.start();
    }
}

