/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.engine.http.connector.AcceptorTask;
import org.restlet.engine.http.connector.BaseHelper;
import org.restlet.engine.http.connector.ConnectedRequest;
import org.restlet.engine.http.connector.ServerConnection;
import org.restlet.engine.log.LoggingThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServerHelper
extends BaseHelper<Server> {
    private volatile ExecutorService acceptorService;
    private volatile AcceptorTask acceptorTask;
    private volatile CountDownLatch latch;
    private volatile ServerSocket serverSocket;

    public BaseServerHelper(Server server) {
        super(server, false);
        this.getAttributes().put("ephemeralPort", -1);
    }

    protected ExecutorService createAcceptorService() {
        return Executors.newSingleThreadExecutor(new LoggingThreadFactory(this.getLogger(), false));
    }

    protected ServerSocket createServerSocket() throws IOException {
        ServerSocket result = new ServerSocket();
        result.setReuseAddress(true);
        result.bind(this.createSocketAddress());
        return result;
    }

    protected SocketAddress createSocketAddress() throws IOException {
        if (((Server)this.getHelped()).getAddress() == null) {
            return new InetSocketAddress(((Server)this.getHelped()).getPort());
        }
        return new InetSocketAddress(((Server)this.getHelped()).getAddress(), ((Server)this.getHelped()).getPort());
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        ((Server)this.getHelped()).handle(request, response);
    }

    @Override
    public void handleInbound(Response response) {
        if (response != null && response.getRequest() != null) {
            ConnectedRequest request = (ConnectedRequest)response.getRequest();
            this.handle(request, response);
            if (!response.isCommitted() && response.isAutoCommitting()) {
                this.getOutboundMessages().add(response);
                response.setCommitted(true);
            }
        }
        this.handleNextOutbound();
    }

    @Override
    public void handleOutbound(Response response) {
        if (response != null) {
            ConnectedRequest request = (ConnectedRequest)response.getRequest();
            ServerConnection connection = request.getConnection();
            if (request.isExpectingResponse()) {
                Response nextResponse = connection.getInboundMessages().peek();
                if (nextResponse != null && nextResponse.getRequest() == request) {
                    connection.getOutboundMessages().add(response);
                    if (!response.getStatus().isInformational()) {
                        connection.getInboundMessages().remove(nextResponse);
                    }
                    connection.writeMessages();
                } else {
                    this.getOutboundMessages().add(response);
                }
            } else {
                connection.setInboundBusy(false);
            }
        }
    }

    public void setEphemeralPort(int localPort) {
        if (((Server)this.getHelped()).getPort() == 0) {
            this.getAttributes().put("ephemeralPort", localPort);
        }
    }

    public void setEphemeralPort(ServerSocket socket) {
        this.setEphemeralPort(socket.getLocalPort());
    }

    @Override
    public synchronized void start() throws Exception {
        super.start();
        this.acceptorService = this.createAcceptorService();
        this.serverSocket = this.createServerSocket();
        this.setEphemeralPort(this.serverSocket);
        this.latch = new CountDownLatch(1);
        this.acceptorTask = new AcceptorTask(this, this.latch);
        this.acceptorService.submit(this.acceptorTask);
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            this.getLogger().log(Level.WARNING, "Interrupted while waiting for starting latch. Stopping...", ex);
            this.stop();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.acceptorService != null) {
            try {
                this.getServerSocket().close();
                this.acceptorTask.setRunning(false);
                this.acceptorService.shutdown();
                this.acceptorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.FINE, "Interruption while shutting down the acceptor service", ex);
            }
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        super.stop();
        this.getAttributes().put("ephemeralPort", -1);
    }
}

