/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.restlet.security.LocalVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVerifier
extends LocalVerifier {
    private final ConcurrentMap<String, char[]> localSecrets;

    public MapVerifier() {
        this(new ConcurrentHashMap<String, char[]>());
    }

    public MapVerifier(ConcurrentMap<String, char[]> localSecrets) {
        this.localSecrets = localSecrets;
    }

    @Override
    public char[] getLocalSecret(String identifier) {
        return identifier == null ? null : (char[])this.getLocalSecrets().get(identifier);
    }

    public ConcurrentMap<String, char[]> getLocalSecrets() {
        return this.localSecrets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalSecrets(Map<String, char[]> secrets) {
        ConcurrentMap<String, char[]> concurrentMap = this.localSecrets;
        synchronized (concurrentMap) {
            this.localSecrets.clear();
            this.localSecrets.putAll(secrets);
        }
    }
}

