/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.HashMap;
import java.util.Map;
import org.restlet.data.Form;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.NamedValue;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaType
extends Metadata {
    private static final String _TSPECIALS = "()<>@,;:/[]?=\\\"";
    private static volatile Map<String, MediaType> _types = null;
    public static final MediaType ALL = MediaType.register("*/*", "All media");
    public static final MediaType APPLICATION_ALL = MediaType.register("application/*", "All application documents");
    public static final MediaType APPLICATION_ALL_XML = MediaType.register("application/*+xml", "All application/*+xml documents");
    public static final MediaType APPLICATION_ATOM = MediaType.register("application/atom+xml", "Atom document");
    public static final MediaType APPLICATION_ATOMPUB_CATEGORY = MediaType.register("application/atomcat+xml", "Atom category document");
    public static final MediaType APPLICATION_ATOMPUB_SERVICE = MediaType.register("application/atomsvc+xml", "Atom service document");
    public static final MediaType APPLICATION_CAB = MediaType.register("application/vnd.ms-cab-compressed", "Microsoft Cabinet archive");
    public static final MediaType APPLICATION_COMPRESS = MediaType.register("application/x-compress", "Compressed file");
    public static final MediaType APPLICATION_ECORE = MediaType.register("application/x-ecore+xmi+xml", "EMOF ECore metamodel");
    public static final MediaType APPLICATION_EXCEL = MediaType.register("application/vnd.ms-excel", "Microsoft Excel document");
    public static final MediaType APPLICATION_FLASH = MediaType.register("application/x-shockwave-flash", "Shockwave Flash object");
    public static final MediaType APPLICATION_GNU_TAR = MediaType.register("application/x-gtar", "GNU Tar archive");
    public static final MediaType APPLICATION_GNU_ZIP = MediaType.register("application/x-gzip", "GNU Zip archive");
    public static final MediaType APPLICATION_HTTP_COOKIES = MediaType.register("application/x-http-cookies", "HTTP cookies");
    public static final MediaType APPLICATION_JAVA = MediaType.register("application/java", "Java class");
    public static final MediaType APPLICATION_JAVA_ARCHIVE = MediaType.register("application/java-archive", "Java archive");
    public static final MediaType APPLICATION_JAVA_OBJECT = MediaType.register("application/x-java-serialized-object", "Java serialized object");
    public static final MediaType APPLICATION_JAVA_OBJECT_GWT = MediaType.register("application/x-java-serialized-object+gwt", "Java serialized object (using GWT-RPC encoder)");
    public static final MediaType APPLICATION_JAVA_OBJECT_XML = MediaType.register("application/x-java-serialized-object+xml", "Java serialized object (using JavaBeans XML encoder)");
    public static final MediaType APPLICATION_JAVASCRIPT = MediaType.register("application/x-javascript", "Javascript document");
    public static final MediaType APPLICATION_JNLP = MediaType.register("application/x-java-jnlp-file", "JNLP");
    public static final MediaType APPLICATION_JSON = MediaType.register("application/json", "JavaScript Object Notation document");
    public static final MediaType APPLICATION_KML = MediaType.register("application/vnd.google-earth.kml+xml", "Google Earth/Maps KML document");
    public static final MediaType APPLICATION_KMZ = MediaType.register("application/vnd.google-earth.kmz", "Google Earth/Maps KMZ document");
    public static final MediaType APPLICATION_LATEX = MediaType.register("application/x-latex", "LaTeX");
    public static final MediaType APPLICATION_MAC_BINHEX40 = MediaType.register("application/mac-binhex40", "Mac binhex40");
    public static final MediaType APPLICATION_MATHML = MediaType.register("application/mathml+xml", "MathML XML document");
    public static final MediaType APPLICATION_MSML = MediaType.register("application/msml+xml", "Media Server Markup Language");
    public static final MediaType APPLICATION_MSOFFICE_DOCM = MediaType.register("application/vnd.ms-word.document.macroEnabled.12", "Office Word 2007 macro-enabled document");
    public static final MediaType APPLICATION_MSOFFICE_DOCX = MediaType.register("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Microsoft Office Word 2007 document");
    public static final MediaType APPLICATION_MSOFFICE_DOTM = MediaType.register("application/vnd.ms-word.template.macroEnabled.12", "Office Word 2007 macro-enabled document template");
    public static final MediaType APPLICATION_MSOFFICE_DOTX = MediaType.register("application/vnd.openxmlformats-officedocument.wordprocessingml.template", "Office Word 2007 template");
    public static final MediaType APPLICATION_MSOFFICE_ONETOC = MediaType.register("application/onenote", "Microsoft Office OneNote 2007 TOC");
    public static final MediaType APPLICATION_MSOFFICE_ONETOC2 = MediaType.register("application/onenote", "Office OneNote 2007 TOC");
    public static final MediaType APPLICATION_MSOFFICE_POTM = MediaType.register("application/vnd.ms-powerpoint.template.macroEnabled.12", "Office PowerPoint 2007 macro-enabled presentation template");
    public static final MediaType APPLICATION_MSOFFICE_POTX = MediaType.register("application/vnd.openxmlformats-officedocument.presentationml.template", "Office PowerPoint 2007 template");
    public static final MediaType APPLICATION_MSOFFICE_PPAM = MediaType.register("application/vnd.ms-powerpoint.addin.macroEnabled.12", "Office PowerPoint 2007 add-in");
    public static final MediaType APPLICATION_MSOFFICE_PPSM = MediaType.register("application/vnd.ms-powerpoint.slideshow.macroEnabled.12", "Office PowerPoint 2007 macro-enabled slide show");
    public static final MediaType APPLICATION_MSOFFICE_PPSX = MediaType.register("application/vnd.openxmlformats-officedocument.presentationml.slideshow", "Office PowerPoint 2007 slide show");
    public static final MediaType APPLICATION_MSOFFICE_PPTM = MediaType.register("application/vnd.ms-powerpoint.presentation.macroEnabled.12", "Office PowerPoint 2007 macro-enabled presentation");
    public static final MediaType APPLICATION_MSOFFICE_PPTX = MediaType.register("application/vnd.openxmlformats-officedocument.presentationml.presentation", "Microsoft Office PowerPoint 2007 presentation");
    public static final MediaType APPLICATION_MSOFFICE_SLDM = MediaType.register("application/vnd.ms-powerpoint.slide.macroEnabled.12", "Office PowerPoint 2007 macro-enabled slide");
    public static final MediaType APPLICATION_MSOFFICE_SLDX = MediaType.register("application/vnd.openxmlformats-officedocument.presentationml.slide", "Office PowerPoint 2007 slide");
    public static final MediaType APPLICATION_MSOFFICE_XLAM = MediaType.register("application/vnd.ms-excel.addin.macroEnabled.12", "Office Excel 2007 add-in");
    public static final MediaType APPLICATION_MSOFFICE_XLSB = MediaType.register("application/vnd.ms-excel.sheet.binary.macroEnabled.12", "Office Excel 2007 binary workbook");
    public static final MediaType APPLICATION_MSOFFICE_XLSM = MediaType.register("application/vnd.ms-excel.sheet.macroEnabled.12", "Office Excel 2007 macro-enabled workbook");
    public static final MediaType APPLICATION_MSOFFICE_XLSX = MediaType.register("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Microsoft Office Excel 2007 workbook");
    public static final MediaType APPLICATION_MSOFFICE_XLTM = MediaType.register("application/vnd.ms-excel.template.macroEnabled.12", "Office Excel 2007 macro-enabled workbook template");
    public static final MediaType APPLICATION_MSOFFICE_XLTX = MediaType.register("application/vnd.openxmlformats-officedocument.spreadsheetml.template", "Office Excel 2007 template");
    public static final MediaType APPLICATION_OCTET_STREAM = MediaType.register("application/octet-stream", "Raw octet stream");
    public static final MediaType APPLICATION_OPENOFFICE_ODB = MediaType.register("application/vnd.oasis.opendocument.database", "OpenDocument Database");
    public static final MediaType APPLICATION_OPENOFFICE_ODC = MediaType.register("application/vnd.oasis.opendocument.chart", "OpenDocument Chart");
    public static final MediaType APPLICATION_OPENOFFICE_ODF = MediaType.register("application/vnd.oasis.opendocument.formula", "OpenDocument Formula");
    public static final MediaType APPLICATION_OPENOFFICE_ODG = MediaType.register("application/vnd.oasis.opendocument.graphics", "OpenDocument Drawing");
    public static final MediaType APPLICATION_OPENOFFICE_ODI = MediaType.register("application/vnd.oasis.opendocument.image", "OpenDocument Image ");
    public static final MediaType APPLICATION_OPENOFFICE_ODM = MediaType.register("application/vnd.oasis.opendocument.text-master", "OpenDocument Master Document");
    public static final MediaType APPLICATION_OPENOFFICE_ODP = MediaType.register("application/vnd.oasis.opendocument.presentation", "OpenDocument Presentation ");
    public static final MediaType APPLICATION_OPENOFFICE_ODS = MediaType.register("application/vnd.oasis.opendocument.spreadsheet", "OpenDocument Spreadsheet");
    public static final MediaType APPLICATION_OPENOFFICE_ODT = MediaType.register("application/vnd.oasis.opendocument.text ", "OpenDocument Text");
    public static final MediaType APPLICATION_OPENOFFICE_OTG = MediaType.register("application/vnd.oasis.opendocument.graphics-template", "OpenDocument Drawing Template");
    public static final MediaType APPLICATION_OPENOFFICE_OTH = MediaType.register("application/vnd.oasis.opendocument.text-web", "HTML Document Template");
    public static final MediaType APPLICATION_OPENOFFICE_OTP = MediaType.register("application/vnd.oasis.opendocument.presentation-template", "OpenDocument Presentation Template");
    public static final MediaType APPLICATION_OPENOFFICE_OTS = MediaType.register("application/vnd.oasis.opendocument.spreadsheet-template", "OpenDocument Spreadsheet Template");
    public static final MediaType APPLICATION_OPENOFFICE_OTT = MediaType.register("application/vnd.oasis.opendocument.text-template", "OpenDocument Text Template");
    public static final MediaType APPLICATION_OPENOFFICE_OXT = MediaType.register("application/vnd.openofficeorg.extension", "OpenOffice.org extension");
    public static final MediaType APPLICATION_PDF = MediaType.register("application/pdf", "Adobe PDF document");
    public static final MediaType APPLICATION_POSTSCRIPT = MediaType.register("application/postscript", "Postscript document");
    public static final MediaType APPLICATION_POWERPOINT = MediaType.register("application/vnd.ms-powerpoint", "Microsoft Powerpoint document");
    public static final MediaType APPLICATION_PROJECT = MediaType.register("application/vnd.ms-project", "Microsoft Project document");
    public static final MediaType APPLICATION_RDF_TRIG = MediaType.register("application/x-trig", "Plain text serialized Resource Description Framework document");
    public static final MediaType APPLICATION_RDF_TRIX = MediaType.register("application/trix", "Simple XML serialized Resource Description Framework document");
    public static final MediaType APPLICATION_RDF_TURTLE = MediaType.register("application/x-turtle", "Plain text serialized Resource Description Framework document");
    public static final MediaType APPLICATION_RDF_XML = MediaType.register("application/rdf+xml", "Normalized XML serialized Resource Description Framework document");
    public static final MediaType APPLICATION_RELAXNG_COMPACT = MediaType.register("application/relax-ng-compact-syntax", "Relax NG Schema document, Compact syntax");
    public static final MediaType APPLICATION_RELAXNG_XML = MediaType.register("application/x-relax-ng+xml", "Relax NG Schema document, XML syntax");
    public static final MediaType APPLICATION_RSS = MediaType.register("application/rss+xml", "Really Simple Syndication document");
    public static final MediaType APPLICATION_RTF = MediaType.register("application/rtf", "Rich Text Format document");
    public static final MediaType APPLICATION_SDP = MediaType.register("application/sdp", "Session Description Protocol");
    public static final MediaType APPLICATION_SPARQL_RESULTS_JSON = MediaType.register("application/sparql-results+json", "SPARQL Query Results JSON document");
    public static final MediaType APPLICATION_SPARQL_RESULTS_XML = MediaType.register("application/sparql-results+xml", "SPARQL Query Results XML document");
    public static final MediaType APPLICATION_SPSS_SAV = MediaType.register("application/x-spss-sav", "SPSS Data");
    public static final MediaType APPLICATION_SPSS_SPS = MediaType.register("application/x-spss-sps", "SPSS Script Syntax");
    public static final MediaType APPLICATION_STATA_STA = MediaType.register("application/x-stata", "Stata data file");
    public static final MediaType APPLICATION_STUFFIT = MediaType.register("application/x-stuffit", "Stuffit archive");
    public static final MediaType APPLICATION_TAR = MediaType.register("application/x-tar", "Tar archive");
    public static final MediaType APPLICATION_TEX = MediaType.register("application/x-tex", "Tex file");
    public static final MediaType APPLICATION_TROFF_MAN = MediaType.register("application/x-troff-man", "LaTeX");
    public static final MediaType APPLICATION_VOICEXML = MediaType.register("application/voicexml+xml", "VoiceXML");
    public static final MediaType APPLICATION_W3C_SCHEMA = MediaType.register("application/x-xsd+xml", "W3C XML Schema document");
    public static final MediaType APPLICATION_W3C_XSLT = MediaType.register("application/xslt+xml", "W3C XSLT Stylesheet");
    public static final MediaType APPLICATION_WADL = MediaType.register("application/vnd.sun.wadl+xml", "Web Application Description Language document");
    public static final MediaType APPLICATION_WORD = MediaType.register("application/msword", "Microsoft Word document");
    public static final MediaType APPLICATION_WWW_FORM = MediaType.register("application/x-www-form-urlencoded", "Web form (URL encoded)");
    public static final MediaType APPLICATION_XHTML = MediaType.register("application/xhtml+xml", "XHTML document");
    public static final MediaType APPLICATION_XMI = MediaType.register("application/xmi+xml", "XMI document");
    @Deprecated
    public static final MediaType APPLICATION_XMI_XML = MediaType.register("application/xmi+xml", "XMI document");
    public static final MediaType APPLICATION_XML = MediaType.register("application/xml", "XML document");
    public static final MediaType APPLICATION_XML_DTD = MediaType.register("application/xml-dtd", "XML DTD");
    public static final MediaType APPLICATION_XUL = MediaType.register("application/vnd.mozilla.xul+xml", "XUL document");
    public static final MediaType APPLICATION_ZIP = MediaType.register("application/zip", "Zip archive");
    public static final MediaType AUDIO_ALL = MediaType.register("audio/*", "All audios");
    public static final MediaType AUDIO_BASIC = MediaType.register("audio/basic", "AU audio");
    public static final MediaType AUDIO_MIDI = MediaType.register("audio/midi", "MIDI audio");
    public static final MediaType AUDIO_MPEG = MediaType.register("audio/mpeg", "MPEG audio (MP3)");
    public static final MediaType AUDIO_REAL = MediaType.register("audio/x-pn-realaudio", "Real audio");
    public static final MediaType AUDIO_WAV = MediaType.register("audio/x-wav", "Waveform audio");
    public static final MediaType IMAGE_ALL = MediaType.register("image/*", "All images");
    public static final MediaType IMAGE_BMP = MediaType.register("image/bmp", "Windows bitmap");
    public static final MediaType IMAGE_GIF = MediaType.register("image/gif", "GIF image");
    public static final MediaType IMAGE_ICON = MediaType.register("image/x-icon", "Windows icon (Favicon)");
    public static final MediaType IMAGE_JPEG = MediaType.register("image/jpeg", "JPEG image");
    public static final MediaType IMAGE_PNG = MediaType.register("image/png", "PNG image");
    public static final MediaType IMAGE_SVG = MediaType.register("image/svg+xml", "Scalable Vector Graphics");
    public static final MediaType IMAGE_TIFF = MediaType.register("image/tiff", "TIFF image");
    public static final MediaType MESSAGE_ALL = MediaType.register("message/*", "All messages");
    public static final MediaType MESSAGE_HTTP = MediaType.register("message/http", "HTTP message");
    public static final MediaType MODEL_ALL = MediaType.register("model/*", "All models");
    public static final MediaType MODEL_VRML = MediaType.register("model/vrml", "VRML");
    public static final MediaType MULTIPART_ALL = MediaType.register("multipart/*", "All multipart data");
    public static final MediaType MULTIPART_FORM_DATA = MediaType.register("multipart/form-data", "Multipart form data");
    public static final MediaType TEXT_ALL = MediaType.register("text/*", "All texts");
    public static final MediaType TEXT_CALENDAR = MediaType.register("text/calendar", "iCalendar event");
    public static final MediaType TEXT_CSS = MediaType.register("text/css", "CSS stylesheet");
    public static final MediaType TEXT_CSV = MediaType.register("text/csv", "Comma-separated Values");
    public static final MediaType TEXT_DAT = MediaType.register("text/x-fixed-field", "Fixed-width Values");
    public static final MediaType TEXT_HTML = MediaType.register("text/html", "HTML document");
    public static final MediaType TEXT_J2ME_APP_DESCRIPTOR = MediaType.register("text/vnd.sun.j2me.app-descriptor", "J2ME Application Descriptor");
    public static final MediaType TEXT_JAVASCRIPT = MediaType.register("text/javascript", "Javascript document");
    public static final MediaType TEXT_PLAIN = MediaType.register("text/plain", "Plain text");
    public static final MediaType TEXT_RDF_N3 = MediaType.register("text/n3", "N3 serialized Resource Description Framework document");
    public static final MediaType TEXT_RDF_NTRIPLES = MediaType.register("text/n-triples", "N-Triples serialized Resource Description Framework document");
    public static final MediaType TEXT_TSV = MediaType.register("text/tab-separated-values", "Tab-separated Values");
    public static final MediaType TEXT_URI_LIST = MediaType.register("text/uri-list", "List of URIs");
    public static final MediaType TEXT_VCARD = MediaType.register("text/x-vcard", "vCard");
    public static final MediaType TEXT_XML = MediaType.register("text/xml", "XML text");
    public static final MediaType VIDEO_ALL = MediaType.register("video/*", "All videos");
    public static final MediaType VIDEO_AVI = MediaType.register("video/x-msvideo", "AVI video");
    public static final MediaType VIDEO_MP4 = MediaType.register("video/mp4", "MPEG-4 video");
    public static final MediaType VIDEO_MPEG = MediaType.register("video/mpeg", "MPEG video");
    public static final MediaType VIDEO_QUICKTIME = MediaType.register("video/quicktime", "Quicktime video");
    public static final MediaType VIDEO_WMV = MediaType.register("video/x-ms-wmv", "Windows movie");
    private volatile Series<Parameter> parameters;

    public static MediaType getMostSpecific(MediaType ... mediaTypes) throws IllegalArgumentException {
        if (mediaTypes == null || mediaTypes.length == 0) {
            throw new IllegalArgumentException("You must give at least one MediaType");
        }
        if (mediaTypes.length == 1) {
            return mediaTypes[0];
        }
        MediaType mostSpecific = mediaTypes[0];
        for (int i = 1; i < mediaTypes.length; ++i) {
            MediaType mediaType = mediaTypes[i];
            if (mediaType == null || mediaType.getMainType().equals("*")) continue;
            if (mostSpecific.getMainType().equals("*")) {
                mostSpecific = mediaType;
                continue;
            }
            if (!mostSpecific.getSubType().contains("*")) continue;
            mostSpecific = mediaType;
        }
        return mostSpecific;
    }

    private static Map<String, MediaType> getTypes() {
        if (_types == null) {
            _types = new HashMap<String, MediaType>();
        }
        return _types;
    }

    private static String normalizeToken(String token) {
        if ("".equals(token = token.trim()) || "*".equals(token)) {
            return "*";
        }
        int length = token.length();
        for (int i = 0; i < length; ++i) {
            char c = token.charAt(i);
            if (c > ' ' && c < '\u007f' && _TSPECIALS.indexOf(c) == -1) continue;
            throw new IllegalArgumentException("Illegal token: " + token);
        }
        return token;
    }

    private static String normalizeType(String name, Series<Parameter> parameters) {
        String subType;
        String mainType;
        int slashIndex;
        StringBuilder params = null;
        if (name == null) {
            return null;
        }
        int colonIndex = name.indexOf(59);
        if (colonIndex != -1) {
            params = new StringBuilder(name.substring(colonIndex));
            name = name.substring(0, colonIndex);
        }
        if ((slashIndex = name.indexOf(47)) == -1) {
            mainType = MediaType.normalizeToken(name);
            subType = "*";
        } else {
            mainType = MediaType.normalizeToken(name.substring(0, slashIndex));
            subType = MediaType.normalizeToken(name.substring(slashIndex + 1));
        }
        if (parameters != null && !parameters.isEmpty()) {
            if (params == null) {
                params = new StringBuilder();
            }
            HeaderWriter<Parameter> hw = new HeaderWriter<Parameter>(){

                @Override
                public HeaderWriter<Parameter> append(Parameter value) {
                    return this.appendExtension(value);
                }
            };
            for (int i = 0; i < parameters.size(); ++i) {
                Parameter p = (Parameter)parameters.get(i);
                hw.appendParameterSeparator();
                hw.appendSpace();
                hw.append(p);
            }
            params.append(hw.toString());
        }
        return params == null ? mainType + '/' + subType : mainType + '/' + subType + params.toString();
    }

    public static synchronized MediaType register(String name, String description) {
        if (!MediaType.getTypes().containsKey(name)) {
            MediaType type = new MediaType(name, description);
            MediaType.getTypes().put(name, type);
        }
        return MediaType.getTypes().get(name);
    }

    public static MediaType valueOf(String name) {
        MediaType result = null;
        if (name != null && !name.equals("") && (result = MediaType.getTypes().get(name)) == null) {
            result = new MediaType(name);
        }
        return result;
    }

    public MediaType(String name) {
        this(name, null, "Media type or range of media types");
    }

    public MediaType(String name, Series<Parameter> parameters) {
        this(name, parameters, "Media type or range of media types");
    }

    public MediaType(String name, Series<Parameter> parameters, String description) {
        super(MediaType.normalizeType(name, parameters), description);
        if (parameters != null) {
            this.parameters = Series.unmodifiableSeries(parameters);
        }
    }

    public MediaType(String name, String description) {
        this(name, null, description);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean ignoreParameters) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof MediaType) {
            MediaType that = (MediaType)obj;
            if (this.getMainType().equals(that.getMainType()) && this.getSubType().equals(that.getSubType())) {
                result = ignoreParameters || this.getParameters().equals(that.getParameters());
            }
        }
        return result;
    }

    public String getMainType() {
        String result = null;
        if (this.getName() != null) {
            int index = this.getName().indexOf(47);
            if (index == -1) {
                index = this.getName().indexOf(59);
            }
            result = index == -1 ? this.getName() : this.getName().substring(0, index);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Series<Parameter> getParameters() {
        Series<NamedValue> p = this.parameters;
        if (p == null) {
            MediaType mediaType = this;
            synchronized (mediaType) {
                p = this.parameters;
                if (p == null) {
                    int index;
                    Form params = null;
                    if (this.getName() != null && (index = this.getName().indexOf(59)) != -1) {
                        params = new Form(this.getName().substring(index + 1).trim(), ';');
                    }
                    if (params == null) {
                        params = new Series(Parameter.class);
                    }
                    this.parameters = p = Series.unmodifiableSeries(params);
                }
            }
        }
        return p;
    }

    @Override
    public MediaType getParent() {
        MediaType result = null;
        result = this.getParameters().size() > 0 ? MediaType.valueOf(this.getMainType() + "/" + this.getSubType()) : (this.getSubType().equals("*") ? (this.equals(ALL) ? null : ALL) : MediaType.valueOf(this.getMainType() + "/*"));
        return result;
    }

    public String getSubType() {
        String result = null;
        if (this.getName() != null) {
            int separator;
            int slash = this.getName().indexOf(47);
            result = slash == -1 ? "*" : ((separator = this.getName().indexOf(59)) == -1 ? this.getName().substring(slash + 1) : this.getName().substring(slash + 1, separator));
        }
        return result;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(super.hashCode(), this.getParameters());
    }

    @Override
    public boolean includes(Metadata included) {
        boolean result;
        boolean bl = result = this.equals(ALL) || included == null || this.equals(included);
        if (!result && included instanceof MediaType) {
            MediaType includedMediaType = (MediaType)included;
            if (this.getMainType().equals(includedMediaType.getMainType())) {
                if (this.getSubType().equals(includedMediaType.getSubType())) {
                    result = true;
                } else if (this.getSubType().equals("*")) {
                    result = true;
                } else if (this.getSubType().startsWith("*+") && includedMediaType.getSubType().endsWith(this.getSubType().substring(2))) {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean isConcrete() {
        return !this.getName().contains("*");
    }
}

