/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.nativeruntime;

import android.database.CursorWindow;
import android.graphics.Typeface;
import android.os.Build;
import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Priority;
import org.robolectric.pluginapi.NativeRuntimeLoader;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.OsUtil;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.TempDirectory;
import org.robolectric.util.inject.Injector;

@Priority(value=-2147483648)
@AutoService(value={NativeRuntimeLoader.class})
public class DefaultNativeRuntimeLoader
implements NativeRuntimeLoader {
    protected static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final AtomicReference<NativeRuntimeLoader> nativeRuntimeLoader = new AtomicReference();
    protected static final String METHOD_BINDING_FORMAT = "$$robo$$${method}$nativeBinding";
    protected static final ImmutableList<String> CORE_CLASS_NATIVES = ImmutableList.copyOf((Object[])new String[]{"android.animation.PropertyValuesHolder", "android.database.CursorWindow", "android.database.sqlite.SQLiteConnection", "android.database.sqlite.SQLiteRawStatement", "android.media.ImageReader", "android.view.Surface", "com.android.internal.util.VirtualRefBasePtr", "libcore.util.NativeAllocationRegistry"});
    protected static final ImmutableList<String> GRAPHICS_CLASS_NATIVES = ImmutableList.copyOf((Object[])new String[]{"android.graphics.Bitmap", "android.graphics.BitmapFactory", "android.graphics.ByteBufferStreamAdaptor", "android.graphics.Camera", "android.graphics.Canvas", "android.graphics.CanvasProperty", "android.graphics.Color", "android.graphics.ColorFilter", "android.graphics.ColorSpace", "android.graphics.CreateJavaOutputStreamAdaptor", "android.graphics.DrawFilter", "android.graphics.FontFamily", "android.graphics.Gainmap", "android.graphics.Graphics", "android.graphics.HardwareRenderer", "android.graphics.HardwareRendererObserver", "android.graphics.ImageDecoder", "android.graphics.Interpolator", "android.graphics.MaskFilter", "android.graphics.Matrix", "android.graphics.NinePatch", "android.graphics.Paint", "android.graphics.Path", "android.graphics.PathEffect", "android.graphics.PathIterator", "android.graphics.PathMeasure", "android.graphics.Picture", "android.graphics.RecordingCanvas", "android.graphics.Region", "android.graphics.RenderEffect", "android.graphics.RenderNode", "android.graphics.Shader", "android.graphics.Typeface", "android.graphics.YuvImage", "android.graphics.animation.NativeInterpolatorFactory", "android.graphics.animation.RenderNodeAnimator", "android.graphics.drawable.AnimatedVectorDrawable", "android.graphics.drawable.AnimatedImageDrawable", "android.graphics.drawable.VectorDrawable", "android.graphics.fonts.Font", "android.graphics.fonts.FontFamily", "android.graphics.text.LineBreaker", "android.graphics.text.MeasuredText", "android.graphics.text.TextRunShaper", "android.util.PathParser"});
    protected static final ImmutableList<String> DEFERRED_STATIC_INITIALIZERS = ImmutableList.copyOf((Object[])new String[]{"android.graphics.FontFamily", "android.graphics.Path", "android.graphics.PathIterator", "android.graphics.Typeface", "android.graphics.text.MeasuredText$Builder", "android.media.ImageReader"});
    private TempDirectory extractDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectAndLoad() {
        AtomicReference<NativeRuntimeLoader> atomicReference = nativeRuntimeLoader;
        synchronized (atomicReference) {
            if (nativeRuntimeLoader.get() == null) {
                Injector injector = new Injector.Builder(CursorWindow.class.getClassLoader()).build();
                NativeRuntimeLoader loader = (NativeRuntimeLoader)injector.getInstance(NativeRuntimeLoader.class);
                nativeRuntimeLoader.set(loader);
            }
        }
        nativeRuntimeLoader.get().ensureLoaded();
    }

    public synchronized void ensureLoaded() {
        if (loaded.get()) {
            return;
        }
        if (!DefaultNativeRuntimeLoader.isSupported()) {
            String errorMessage = String.format("The Robolectric native runtime is not supported on %s (%s)", StandardSystemProperty.OS_NAME.value(), StandardSystemProperty.OS_ARCH.value());
            throw new AssertionError((Object)errorMessage);
        }
        loaded.set(true);
        try {
            PerfStatsCollector.getInstance().measure("loadNativeRuntime", () -> {
                this.extractDirectory = new TempDirectory("nativeruntime");
                if (Build.VERSION.SDK_INT >= 26) {
                    this.maybeCopyFonts(this.extractDirectory);
                }
                this.maybeCopyIcuData(this.extractDirectory);
                if (DefaultNativeRuntimeLoader.isAndroidVOrGreater()) {
                    System.setProperty("core_native_classes", String.join((CharSequence)",", CORE_CLASS_NATIVES));
                    System.setProperty("graphics_native_classes", String.join((CharSequence)",", GRAPHICS_CLASS_NATIVES));
                    System.setProperty("method_binding_format", METHOD_BINDING_FORMAT);
                }
                this.loadLibrary(this.extractDirectory);
                if (DefaultNativeRuntimeLoader.isAndroidVOrGreater()) {
                    this.invokeDeferredStaticInitializers();
                    Typeface.loadPreinstalledSystemFontMap();
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load Robolectric native runtime library", e);
        }
    }

    private void maybeCopyIcuData(TempDirectory tempDirectory) throws IOException {
        URL icuDatUrl;
        try {
            icuDatUrl = Resources.getResource((String)(DefaultNativeRuntimeLoader.isAndroidVOrGreater() ? "icu/icudt75l.dat" : "icu/icudt68l.dat"));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Path icuPath = tempDirectory.create("icu");
        Path icuDatPath = icuPath.resolve(DefaultNativeRuntimeLoader.isAndroidVOrGreater() ? "icudt75l.dat" : "icudt68l.dat");
        Resources.asByteSource((URL)icuDatUrl).copyTo(com.google.common.io.Files.asByteSink((File)icuDatPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
        System.setProperty("icu.data.path", icuDatPath.toAbsolutePath().toString());
        System.setProperty("icu.locale.default", Locale.getDefault().toLanguageTag());
    }

    private void maybeCopyFonts(TempDirectory tempDirectory) throws IOException {
        URI fontsUri = null;
        try {
            fontsUri = Resources.getResource((String)"fonts/").toURI();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return;
        }
        FileSystem zipfs = null;
        if ("jar".equals(fontsUri.getScheme())) {
            zipfs = FileSystems.newFileSystem(fontsUri, ImmutableMap.of((Object)"create", (Object)"true"));
        }
        Path fontsInputPath = Paths.get(fontsUri);
        Path fontsOutputPath = tempDirectory.create("fonts");
        try (Stream<Path> pathStream = Files.walk(fontsInputPath, new FileVisitOption[0]);){
            Iterator fileIterator = pathStream.iterator();
            while (fileIterator.hasNext()) {
                Path path = (Path)fileIterator.next();
                if ("fonts".equals(path.getFileName().toString())) continue;
                String fontPath = "fonts/" + path.getFileName();
                URL resource = Resources.getResource((String)fontPath);
                Path outputPath = tempDirectory.getBasePath().resolve(fontPath);
                Resources.asByteSource((URL)resource).copyTo(com.google.common.io.Files.asByteSink((File)outputPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
            }
        }
        System.setProperty("robolectric.nativeruntime.fontdir", fontsOutputPath.toAbsolutePath() + File.separator);
        if (zipfs != null) {
            zipfs.close();
        }
    }

    private void loadLibrary(TempDirectory tempDirectory) throws IOException {
        Path libraryPath = tempDirectory.getBasePath().resolve(DefaultNativeRuntimeLoader.libraryName());
        URL libraryResource = Resources.getResource((String)DefaultNativeRuntimeLoader.nativeLibraryPath());
        Resources.asByteSource((URL)libraryResource).copyTo(com.google.common.io.Files.asByteSink((File)libraryPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
        System.load(libraryPath.toAbsolutePath().toString());
    }

    private static boolean isSupported() {
        return OsUtil.isMac() && (Objects.equals(DefaultNativeRuntimeLoader.arch(), "aarch64") || Objects.equals(DefaultNativeRuntimeLoader.arch(), "x86_64")) || OsUtil.isLinux() && Objects.equals(DefaultNativeRuntimeLoader.arch(), "x86_64") || OsUtil.isWindows() && Objects.equals(DefaultNativeRuntimeLoader.arch(), "x86_64");
    }

    private static String nativeLibraryPath() {
        return String.format("native/%s/%s/%s", DefaultNativeRuntimeLoader.osName(), DefaultNativeRuntimeLoader.arch(), DefaultNativeRuntimeLoader.libraryName());
    }

    private static String libraryName() {
        if (DefaultNativeRuntimeLoader.isAndroidVOrGreater()) {
            return System.mapLibraryName(OsUtil.isWindows() ? "libandroid_runtime" : "android_runtime");
        }
        return System.mapLibraryName("robolectric-nativeruntime");
    }

    private static String osName() {
        if (OsUtil.isLinux()) {
            return "linux";
        }
        if (OsUtil.isMac()) {
            return "mac";
        }
        if (OsUtil.isWindows()) {
            return "windows";
        }
        return "unknown";
    }

    private static String arch() {
        String arch = StandardSystemProperty.OS_ARCH.value().toLowerCase(Locale.US);
        if (arch.equals("x86_64") || arch.equals("amd64")) {
            return "x86_64";
        }
        return arch;
    }

    @VisibleForTesting
    static boolean isLoaded() {
        return loaded.get();
    }

    @VisibleForTesting
    Path getDirectory() {
        return this.extractDirectory == null ? null : this.extractDirectory.getBasePath();
    }

    @VisibleForTesting
    static void resetLoaded() {
        loaded.set(false);
    }

    protected void invokeDeferredStaticInitializers() {
        for (String className : DEFERRED_STATIC_INITIALIZERS) {
            ReflectionHelpers.callStaticMethod((ClassLoader)Shadow.class.getClassLoader(), (String)className, (String)"__staticInitializer__", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    private static boolean isAndroidVOrGreater() {
        return Build.VERSION.SDK_INT >= 35;
    }
}

