/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResType;
import org.robolectric.res.StaxLoader;
import org.robolectric.res.StringResources;
import org.robolectric.res.TextCollectingNodeHandler;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlContext;

public class StaxValueLoader
extends StaxLoader {
    private final StringBuilder buf = new StringBuilder();
    protected String name;

    public StaxValueLoader(PackageResourceTable resourceTable, String attrType, ResType resType) {
        super(resourceTable, attrType, resType);
        if (resType == ResType.CHAR_SEQUENCE) {
            this.addHandler("*", new TextCollectingNodeHandler(this.buf));
        }
    }

    @Override
    public void onStart(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        this.name = xml.getAttributeValue(null, "name");
        this.buf.setLength(0);
    }

    @Override
    public void onCharacters(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        this.buf.append(xml.getText());
    }

    @Override
    public void onEnd(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        String s = this.buf.toString();
        s = this.resType == ResType.CHAR_SEQUENCE ? StringResources.processStringResources(s) : s.trim();
        this.resourceTable.addResource(this.attrType, this.name, new TypedResource<String>(s, this.resType, xmlContext));
    }
}

