/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.Util;

public class FileMap {
    private static final int ENDSIG = 101010256;
    private static final int ENDHDR = 22;
    private static final int ENDSIG64 = 101075792;
    private static final int MAXIMUM_ZIP_EOCD_SIZE = 65558;
    private ZipFile zipFile;
    private ZipEntry zipEntry;
    private boolean readOnly;
    private int fd;
    private boolean isFromZip;
    String mFileName;
    int mBasePtr;
    int mBaseLength;
    long mDataOffset;
    byte[] mDataPtr;
    int mDataLength;
    static long mPageSize;

    boolean create(String origFileName, int fd, long offset, int length, boolean readOnly) {
        this.mFileName = origFileName;
        this.fd = fd;
        this.mDataOffset = offset;
        this.readOnly = readOnly;
        return true;
    }

    boolean createFromZip(String origFileName, ZipFile zipFile, ZipEntry entry, long offset, int length, boolean readOnly) {
        this.isFromZip = true;
        this.zipFile = zipFile;
        this.zipEntry = entry;
        assert (this.fd >= 0);
        assert (offset >= 0L);
        this.mFileName = origFileName != null ? origFileName : null;
        this.mDataOffset = offset;
        this.mDataLength = Asset.toIntExact(entry.getSize());
        Util.ALOGV("MAP: base %s/0x%x data %s/0x%x\n", this.mBasePtr, this.mBaseLength, this.mDataPtr, this.mDataLength);
        return true;
    }

    static ImmutableMap<String, Long> guessDataOffsets(File zipFile, int length) {
        ImmutableMap immutableMap;
        ImmutableMap.Builder result = ImmutableMap.builder();
        RandomAccessFile randomAccessFile = new RandomAccessFile(zipFile, "r");
        try {
            int sig;
            int endOfCdSize = Math.min(65558, length);
            int endofCdOffset = length - endOfCdSize;
            randomAccessFile.seek(endofCdOffset);
            byte[] buffer = new byte[endOfCdSize];
            randomAccessFile.readFully(buffer);
            int centralDirOffset = FileMap.findCentralDir(buffer);
            int offset = centralDirOffset - endofCdOffset;
            if (offset < 0) {
                offset = 0;
                randomAccessFile.seek(centralDirOffset);
                int cdSize = length - centralDirOffset;
                buffer = new byte[cdSize];
                randomAccessFile.readFully(buffer);
            }
            while ((sig = FileMap.readInt(buffer, offset)) != 101010256 && sig != 101075792) {
                short bitFlag = FileMap.readShort(buffer, offset + 8);
                short fileNameLength = FileMap.readShort(buffer, offset + 28);
                short extraLength = FileMap.readShort(buffer, offset + 30);
                short fieldCommentLength = FileMap.readShort(buffer, offset + 32);
                int relativeOffsetOfLocalFileHeader = FileMap.readInt(buffer, offset + 42);
                byte[] nameBytes = FileMap.copyBytes(buffer, offset + 46, fileNameLength);
                Charset encoding = FileMap.getEncoding(bitFlag);
                String fileName = new String(nameBytes, encoding);
                result.put((Object)fileName, (Object)(relativeOffsetOfLocalFileHeader + 30 + fileNameLength + extraLength));
                offset += 46 + fileNameLength + extraLength + fieldCommentLength;
            }
            immutableMap = result.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    randomAccessFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        randomAccessFile.close();
        return immutableMap;
    }

    private static byte[] copyBytes(byte[] buffer, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(buffer, offset, result, 0, length);
        return result;
    }

    private static Charset getEncoding(int bitFlags) {
        return 0 != (bitFlags >>> 11 & 1) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
    }

    private static int findCentralDir(byte[] buffer) throws IOException {
        int val;
        int scanOffset = buffer.length - 22;
        while ((val = FileMap.readInt(buffer, scanOffset)) != 101010256) {
            if (--scanOffset >= 0) continue;
            throw new ZipException("ZIP directory not found, not a ZIP archive.");
        }
        int offsetToCentralDir = FileMap.readInt(buffer, scanOffset + 16);
        return offsetToCentralDir;
    }

    private static int readInt(byte[] buffer, int offset) {
        return Ints.fromBytes((byte)buffer[offset + 3], (byte)buffer[offset + 2], (byte)buffer[offset + 1], (byte)buffer[offset]);
    }

    private static short readShort(byte[] buffer, int offset) {
        return Shorts.fromBytes((byte)buffer[offset + 1], (byte)buffer[offset]);
    }

    String getFileName() {
        return this.mFileName;
    }

    synchronized byte[] getDataPtr() {
        if (this.mDataPtr == null) {
            this.mDataPtr = new byte[this.mDataLength];
            try (InputStream is = this.isFromZip ? this.zipFile.getInputStream(this.zipEntry) : new FileInputStream(this.getFileName());){
                FileMap.readFully(is, this.mDataPtr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mDataPtr;
    }

    public static void readFully(InputStream is, byte[] bytes) throws IOException {
        int size;
        int location;
        int remaining;
        int bytesRead;
        for (remaining = size = bytes.length; remaining > 0 && (bytesRead = is.read(bytes, location = size - remaining, remaining)) != -1; remaining -= bytesRead) {
        }
        if (remaining > 0) {
            int n = remaining;
            throw new RuntimeException(new StringBuilder(53).append("failed to read ").append(size).append(" (").append(n).append(" bytes unread)").toString());
        }
    }

    int getDataLength() {
        return this.mDataLength;
    }

    long getDataOffset() {
        return this.mDataOffset;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public String toString() {
        if (this.isFromZip) {
            String string = this.zipFile.getName();
            String string2 = String.valueOf(this.zipEntry);
            return new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("FileMap{zipFile=").append(string).append(", zipEntry=").append(string2).append('}').toString();
        }
        String string = this.mFileName;
        return new StringBuilder(21 + String.valueOf(string).length()).append("FileMap{mFileName='").append(string).append('\'').append('}').toString();
    }
}

