/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.res.ResName;
import org.robolectric.res.XmlLoader;

public class ResBundle<T> {
    private static final String VERSION_QUALIFIER_REGEX = "v([0-9]+)";
    private static final String PADDED_VERSION_QUALIFIER_REGEX = "-v([0-9]+)-";
    private static final Pattern VERSION_QUALIFIER_PATTERN_WITH_LINE_END = Pattern.compile("v([0-9]+)$");
    private static final Pattern VERSION_QUALIFIER_PATTERN_WITH_DASHES = Pattern.compile("-v([0-9]+)-");
    private final ResMap<T> valuesMap = new ResMap();
    private final ResMap<List<T>> valuesArrayMap = new ResMap();
    private String overrideNamespace;

    public void put(String attrType, String name, T value, XmlLoader.XmlContext xmlContext) {
        ResName resName = new ResName(this.maybeOverride(xmlContext.packageName), attrType, name);
        List<Value<T>> values = this.valuesMap.find(resName);
        values.add(new Value<T>(xmlContext.getQualifiers(), value));
        Collections.sort(values);
    }

    public T get(ResName resName, String qualifiers) {
        Value<T> value = this.getValue(resName, qualifiers);
        return (T)(value == null ? null : ((Value)value).value);
    }

    public Value<T> getValue(ResName resName, String qualifiers) {
        List<Value<T>> values = this.valuesMap.find(this.maybeOverride(resName));
        return values != null ? ResBundle.pick(values, qualifiers) : null;
    }

    public static int getVersionQualifierApiLevel(String qualifiers) {
        Matcher m = VERSION_QUALIFIER_PATTERN_WITH_LINE_END.matcher(qualifiers);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return -1;
    }

    public static <T> Value<T> pick(List<Value<T>> values, String qualifiers) {
        int i;
        int i2;
        int count = values.size();
        if (count == 0) {
            return null;
        }
        BitSet possibles = new BitSet(count);
        possibles.set(0, count);
        StringTokenizer st = new StringTokenizer(qualifiers, "-");
        while (st.hasMoreTokens()) {
            String qualifier = st.nextToken();
            String paddedQualifier = "-" + qualifier + "-";
            BitSet matches = new BitSet(count);
            i2 = possibles.nextSetBit(0);
            while (i2 != -1) {
                if (((Value)values.get(i2)).qualifiers.contains(paddedQualifier)) {
                    matches.set(i2);
                }
                i2 = possibles.nextSetBit(i2 + 1);
            }
            if (!matches.isEmpty()) {
                possibles.and(matches);
            }
            if (matches.cardinality() != 1) continue;
            break;
        }
        int targetApiLevel = ResBundle.getVersionQualifierApiLevel(qualifiers);
        if (qualifiers.length() > 0 && targetApiLevel != -1) {
            Value<T> bestMatch = null;
            int bestMatchDistance = Integer.MAX_VALUE;
            i2 = possibles.nextSetBit(0);
            while (i2 != -1) {
                Value<T> value = values.get(i2);
                int distance = ResBundle.getDistance(value, targetApiLevel);
                String paddedQualifier = "-" + qualifiers + "-";
                String valueWithoutVersion = VERSION_QUALIFIER_PATTERN_WITH_DASHES.matcher(((Value)value).qualifiers).replaceAll("--");
                String qualifierWithoutVersion = VERSION_QUALIFIER_PATTERN_WITH_DASHES.matcher(paddedQualifier).replaceAll("--");
                if (qualifierWithoutVersion.contains(valueWithoutVersion) && distance >= 0 && distance < bestMatchDistance) {
                    bestMatch = value;
                    bestMatchDistance = distance;
                }
                i2 = possibles.nextSetBit(i2 + 1);
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        }
        if ((i = possibles.nextSetBit(0)) != -1) {
            return values.get(i);
        }
        throw new IllegalStateException("couldn't handle qualifiers \"" + qualifiers + "\"");
    }

    private static int getDistance(Value val, int targetApiLevel) {
        int distance = -1;
        Matcher m = VERSION_QUALIFIER_PATTERN_WITH_DASHES.matcher(val.qualifiers);
        if (m.find()) {
            String match = m.group(1);
            int resApiLevel = Integer.parseInt(match);
            distance = targetApiLevel - resApiLevel;
            if (m.find()) {
                throw new IllegalStateException("A resource file was found that had two API level qualifiers: " + val);
            }
        } else if (val.qualifiers.equals("--")) {
            distance = targetApiLevel;
        }
        return distance;
    }

    public int size() {
        return this.valuesMap.size() + this.valuesArrayMap.size();
    }

    public void makeImmutable() {
        this.valuesMap.makeImmutable();
        this.valuesArrayMap.makeImmutable();
    }

    public void overrideNamespace(String overrideNamespace) {
        this.overrideNamespace = overrideNamespace;
        if (this.size() > 0) {
            throw new RuntimeException();
        }
    }

    String maybeOverride(String namespace) {
        return this.overrideNamespace == null ? namespace : this.overrideNamespace;
    }

    ResName maybeOverride(ResName resName) {
        return this.overrideNamespace == null ? resName : new ResName(this.overrideNamespace, resName.type, resName.name);
    }

    public void mergeLibraryStyle(ResBundle<T> fromResBundle, String packageName) {
        ((ResMap)this.valuesMap).merge(packageName, (ResMap)fromResBundle.valuesMap);
        ((ResMap)this.valuesArrayMap).merge(packageName, (ResMap)fromResBundle.valuesArrayMap);
    }

    private static class ResMap<T> {
        private final Map<ResName, List<Value<T>>> map = new HashMap<ResName, List<Value<T>>>();
        private boolean immutable;

        private ResMap() {
        }

        public List<Value<T>> find(ResName resName) {
            List<Value<T>> values = this.map.get(resName);
            if (values == null) {
                values = new ArrayList<Value<T>>();
                this.map.put(resName, values);
            }
            return values;
        }

        private void merge(String packageName, ResMap<T> sourceMap) {
            if (this.immutable) {
                throw new IllegalStateException("immutable!");
            }
            for (Map.Entry<ResName, List<Value<T>>> entry : sourceMap.map.entrySet()) {
                ResName resName = entry.getKey().withPackageName(packageName);
                this.find(resName).addAll((Collection)entry.getValue());
            }
        }

        public int size() {
            return this.map.size();
        }

        public void makeImmutable() {
            this.immutable = true;
        }
    }

    public static class Value<T>
    implements Comparable<Value<T>> {
        private final String qualifiers;
        private final T value;

        Value(String qualifiers, T value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.qualifiers = qualifiers == null ? "--" : "-" + qualifiers + "-";
            this.value = value;
        }

        public String getQualifiers() {
            return this.qualifiers;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Value<T> o) {
            return this.qualifiers.compareTo(o.qualifiers);
        }

        public String toString() {
            return "Value{qualifiers='" + this.qualifiers + '\'' + ", value=" + this.value + '}';
        }
    }
}

