/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.cookie;

import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.cookie.Cookie;
import org.saltyrtc.client.exceptions.ProtocolException;

public class CookiePair {
    private final Cookie ours;
    private Cookie theirs = null;

    public CookiePair() {
        this.ours = new Cookie();
    }

    public CookiePair(Cookie theirs) {
        Cookie cookie;
        while ((cookie = new Cookie()).equals(theirs)) {
        }
        this.ours = cookie;
        this.theirs = theirs;
    }

    public CookiePair(Cookie ours, Cookie theirs) throws ProtocolException {
        if (theirs.equals(ours)) {
            throw new ProtocolException("Their cookie matches our cookie");
        }
        this.ours = ours;
        this.theirs = theirs;
    }

    @NonNull
    public Cookie getOurs() {
        return this.ours;
    }

    public boolean hasTheirs() {
        return this.theirs != null;
    }

    @Nullable
    public Cookie getTheirs() {
        return this.theirs;
    }

    public void setTheirs(Cookie theirs) throws ProtocolException {
        if (theirs.equals(this.ours)) {
            throw new ProtocolException("Their cookie matches our cookie");
        }
        this.theirs = theirs;
    }
}

