/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.events;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.saltyrtc.client.events.Event;
import org.saltyrtc.client.events.EventHandler;

public class EventRegistry<E extends Event> {
    private final Set<EventHandler<E>> handlers = new CopyOnWriteArraySet<EventHandler<E>>();

    public void register(EventHandler<E> handler) {
        this.handlers.add(handler);
    }

    public void unregister(EventHandler<E> handler) {
        this.handlers.remove(handler);
    }

    public void clear() {
        this.handlers.clear();
    }

    public void notifyHandlers(E event) {
        for (EventHandler<E> handler : this.handlers) {
            boolean removeHandler = handler.handle(event);
            if (!removeHandler) continue;
            this.unregister(handler);
        }
    }
}

