/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.helpers;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.saltyrtc.client.helpers.UnsignedHelper;
import org.saltyrtc.client.messages.Message;
import org.saltyrtc.client.nonce.SignalingChannelNonce;
import org.saltyrtc.vendor.com.neilalexander.jnacl.NaCl;

public class MessageHistory {
    private final int maxSize;
    private final Map<String, Message> history;

    public MessageHistory(int maxSize) {
        this.maxSize = maxSize;
        this.history = new LimitedHashMap<String, Message>();
    }

    public synchronized void store(Message message, SignalingChannelNonce nonce) {
        byte[] key = MessageHistory.getMessageKey(nonce);
        this.history.put(NaCl.asHex(key).toLowerCase(), message);
    }

    public static byte[] getMessageKey(SignalingChannelNonce nonce) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(UnsignedHelper.getUnsignedByte(nonce.getSource()));
        buf.put(UnsignedHelper.getUnsignedByte(nonce.getDestination()));
        buf.putShort(UnsignedHelper.getUnsignedShort(nonce.getOverflow()));
        buf.putInt(UnsignedHelper.getUnsignedInt(nonce.getSequence()));
        return buf.array();
    }

    public synchronized Message find(byte[] key) {
        return this.history.get(NaCl.asHex(key).toLowerCase());
    }

    public synchronized Message find(String key) {
        return this.history.get(key.toLowerCase());
    }

    public synchronized int size() {
        return this.history.size();
    }

    private class LimitedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private LimitedHashMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > MessageHistory.this.maxSize;
        }
    }
}

