/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.keystore;

import java.security.SecureRandom;
import org.saltyrtc.client.exceptions.CryptoFailedException;
import org.saltyrtc.client.exceptions.InvalidKeyException;
import org.saltyrtc.client.keystore.Box;
import org.saltyrtc.vendor.com.neilalexander.jnacl.NaCl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthToken {
    private static final Logger LOG = LoggerFactory.getLogger((String)"SaltyRTC.AuthToken");
    private byte[] authToken = new byte[32];

    public AuthToken() {
        SecureRandom random = new SecureRandom();
        random.nextBytes(this.authToken);
        LOG.debug("Generated random auth token");
    }

    public AuthToken(byte[] authToken) throws InvalidKeyException {
        if (authToken.length != 32) {
            throw new InvalidKeyException("Auth token must be 32 bytes long.");
        }
        this.authToken = authToken;
        LOG.debug("Initialized auth token");
    }

    public byte[] getAuthToken() {
        return this.authToken;
    }

    public Box encrypt(byte[] data, byte[] nonce) throws CryptoFailedException {
        byte[] encrypted;
        try {
            encrypted = NaCl.symmetricEncryptData(data, this.authToken, nonce);
        }
        catch (Error e) {
            throw new CryptoFailedException(e.getMessage());
        }
        return new Box(nonce, encrypted);
    }

    public byte[] decrypt(Box box) throws CryptoFailedException {
        byte[] decrypted;
        try {
            decrypted = NaCl.symmetricDecryptData(box.getData(), this.authToken, box.getNonce());
        }
        catch (Error e) {
            throw new CryptoFailedException(e.getMessage());
        }
        if (decrypted == null) {
            throw new CryptoFailedException("Decrypted data is null");
        }
        return decrypted;
    }
}

