/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.keystore;

import org.saltyrtc.client.exceptions.CryptoFailedException;
import org.saltyrtc.client.exceptions.InvalidKeyException;
import org.saltyrtc.client.keystore.Box;
import org.saltyrtc.vendor.com.neilalexander.jnacl.NaCl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)"SaltyRTC.KeyStore");
    private byte[] secretKey = new byte[32];
    private byte[] publicKey = new byte[32];

    public KeyStore() {
        LOG.debug("Generating new key pair");
        NaCl.genkeypair(this.publicKey, this.secretKey);
        LOG.debug("Secret key: " + NaCl.asHex(this.secretKey));
        LOG.debug("Public key: " + NaCl.asHex(this.publicKey));
    }

    public KeyStore(byte[] secretKey) {
        LOG.debug("Deriving public key from secret key");
        this.secretKey = secretKey;
        this.publicKey = NaCl.derivePublicKey(secretKey);
        LOG.debug("Secret key: " + NaCl.asHex(this.secretKey));
        LOG.debug("Public key: " + NaCl.asHex(this.publicKey));
    }

    public KeyStore(byte[] publicKey, byte[] secretKey) {
        LOG.debug("Using existing keypair");
        this.secretKey = secretKey;
        this.publicKey = publicKey;
        LOG.debug("Secret key: " + NaCl.asHex(this.secretKey));
        LOG.debug("Public key: " + NaCl.asHex(this.publicKey));
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public Box encrypt(byte[] data, byte[] nonce, byte[] otherKey) throws CryptoFailedException, InvalidKeyException {
        byte[] encrypted;
        NaCl nacl;
        try {
            nacl = new NaCl(this.secretKey, otherKey);
        }
        catch (Error e) {
            throw new InvalidKeyException(e.toString());
        }
        try {
            encrypted = nacl.encrypt(data, nonce);
        }
        catch (Error e) {
            throw new CryptoFailedException(e.toString());
        }
        if (encrypted == null) {
            throw new CryptoFailedException("Encrypted data is null");
        }
        return new Box(nonce, encrypted);
    }

    public byte[] decrypt(Box box, byte[] otherKey) throws CryptoFailedException, InvalidKeyException {
        byte[] decrypted;
        NaCl nacl;
        try {
            nacl = new NaCl(this.secretKey, otherKey);
        }
        catch (Error e) {
            throw new InvalidKeyException(e.toString());
        }
        try {
            decrypted = nacl.decrypt(box.getData(), box.getNonce());
        }
        catch (Error e) {
            throw new CryptoFailedException(e.toString());
        }
        if (decrypted == null) {
            throw new CryptoFailedException("Decrypted data is null");
        }
        return decrypted;
    }
}

