/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.messages.s2c;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.ValidationHelper;
import org.saltyrtc.client.messages.Message;

public class ClientAuth
extends Message {
    public static final String TYPE = "client-auth";
    private byte[] yourCookie;
    private List<String> subprotocols;

    public ClientAuth(byte[] yourCookie, List<String> subprotocols) {
        this.yourCookie = yourCookie;
        this.subprotocols = subprotocols;
    }

    public ClientAuth(Map<String, Object> map) throws ValidationError {
        ValidationHelper.validateType(map.get("type"), TYPE);
        int COOKIE_LENGTH = 16;
        this.yourCookie = ValidationHelper.validateByteArray(map.get("your_cookie"), 16, "your_cookie");
        this.subprotocols = ValidationHelper.validateTypedList(map.get("subprotocols"), String.class, "subprotocols");
    }

    public byte[] getYourCookie() {
        return this.yourCookie;
    }

    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    @Override
    public void write(MessagePacker packer) throws IOException {
        packer.packMapHeader(3).packString("type").packString(TYPE).packString("your_cookie").packBinaryHeader(this.yourCookie.length).writePayload(this.yourCookie);
        packer.packString("subprotocols").packArrayHeader(this.subprotocols.size());
        for (String subprotocol : this.subprotocols) {
            packer.packString(subprotocol);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

