/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.nonce;

import java.nio.ByteBuffer;
import org.saltyrtc.client.helpers.UnsignedHelper;
import org.saltyrtc.client.nonce.Nonce;

public class SignalingChannelNonce
extends Nonce {
    private short source;
    private short destination;

    public SignalingChannelNonce(byte[] cookie, short source, short destination, int overflow, long sequence) {
        this.validateCookie(cookie);
        this.validateSource(source);
        this.validateDestination(destination);
        this.validateOverflow(overflow);
        this.validateSequence(sequence);
        this.cookie = cookie;
        this.source = source;
        this.destination = destination;
        this.overflow = overflow;
        this.sequence = sequence;
    }

    public SignalingChannelNonce(ByteBuffer buf) {
        if (buf.limit() < 24) {
            throw new IllegalArgumentException("Buffer limit must be at least 24");
        }
        byte[] cookie = new byte[16];
        buf.get(cookie, 0, 16);
        this.validateCookie(cookie);
        short source = UnsignedHelper.readUnsignedByte(buf.get());
        this.validateSource(source);
        short destination = UnsignedHelper.readUnsignedByte(buf.get());
        this.validateDestination(destination);
        int overflow = UnsignedHelper.readUnsignedShort(buf.getShort());
        this.validateOverflow(overflow);
        long sequence = UnsignedHelper.readUnsignedInt(buf.getInt());
        this.validateSequence(sequence);
        this.cookie = cookie;
        this.source = source;
        this.destination = destination;
        this.overflow = overflow;
        this.sequence = sequence;
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(24);
        buffer.put(this.cookie);
        buffer.put(UnsignedHelper.getUnsignedByte(this.source));
        buffer.put(UnsignedHelper.getUnsignedByte(this.destination));
        buffer.putShort(UnsignedHelper.getUnsignedShort(this.overflow));
        buffer.putInt(UnsignedHelper.getUnsignedInt(this.sequence));
        return buffer.array();
    }

    private void validateSource(short source) {
        if (source < 0 || source >= 256) {
            throw new IllegalArgumentException("source must be between 0 and 2**8-1");
        }
    }

    private void validateDestination(short destination) {
        if (destination < 0 || destination >= 256) {
            throw new IllegalArgumentException("destination must be between 0 and 2**8-1");
        }
    }

    public short getSource() {
        return this.source;
    }

    public short getDestination() {
        return this.destination;
    }
}

