/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.signaling;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.saltyrtc.client.SaltyRTC;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.cookie.Cookie;
import org.saltyrtc.client.events.SignalingConnectionLostEvent;
import org.saltyrtc.client.exceptions.ConnectionException;
import org.saltyrtc.client.exceptions.CryptoFailedException;
import org.saltyrtc.client.exceptions.InternalException;
import org.saltyrtc.client.exceptions.InvalidKeyException;
import org.saltyrtc.client.exceptions.ProtocolException;
import org.saltyrtc.client.exceptions.SerializationError;
import org.saltyrtc.client.exceptions.SignalingException;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.MessageReader;
import org.saltyrtc.client.helpers.TaskHelper;
import org.saltyrtc.client.keystore.AuthToken;
import org.saltyrtc.client.keystore.Box;
import org.saltyrtc.client.keystore.KeyStore;
import org.saltyrtc.client.messages.Message;
import org.saltyrtc.client.messages.c2c.InitiatorAuth;
import org.saltyrtc.client.messages.c2c.Key;
import org.saltyrtc.client.messages.c2c.ResponderAuth;
import org.saltyrtc.client.messages.c2c.Token;
import org.saltyrtc.client.messages.s2c.DropResponder;
import org.saltyrtc.client.messages.s2c.InitiatorServerAuth;
import org.saltyrtc.client.messages.s2c.NewResponder;
import org.saltyrtc.client.messages.s2c.SendError;
import org.saltyrtc.client.nonce.SignalingChannelNonce;
import org.saltyrtc.client.signaling.Peer;
import org.saltyrtc.client.signaling.Responder;
import org.saltyrtc.client.signaling.Signaling;
import org.saltyrtc.client.signaling.SignalingRole;
import org.saltyrtc.client.signaling.state.ResponderHandshakeState;
import org.saltyrtc.client.signaling.state.ServerHandshakeState;
import org.saltyrtc.client.signaling.state.SignalingState;
import org.saltyrtc.client.tasks.Task;
import org.saltyrtc.vendor.com.neilalexander.jnacl.NaCl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiatorSignaling
extends Signaling {
    private final Map<Short, Responder> responders = new HashMap<Short, Responder>();
    private Responder responder;

    @Override
    protected Logger getLogger() {
        return LoggerFactory.getLogger((String)"SaltyRTC.ISignaling");
    }

    public InitiatorSignaling(SaltyRTC saltyRTC, String host, int port, KeyStore permanentKey, SSLContext sslContext, @Nullable byte[] responderTrustedKey, @Nullable byte[] expectedServerKey, Task[] tasks) {
        super(saltyRTC, host, port, permanentKey, sslContext, responderTrustedKey, expectedServerKey, SignalingRole.Initiator, tasks);
        if (responderTrustedKey == null) {
            this.authToken = new AuthToken();
        }
    }

    @Override
    protected String getWebsocketPath() {
        return NaCl.asHex(this.permanentKey.getPublicKey());
    }

    @Override
    protected Box encryptHandshakeDataForPeer(short receiver, String messageType, byte[] payload, byte[] nonce) throws CryptoFailedException, InvalidKeyException, ProtocolException {
        Responder responder;
        if (receiver == 1) {
            throw new ProtocolException("Initiator cannot encrypt messages for initiator");
        }
        if (!this.isResponderId(receiver)) {
            throw new ProtocolException("Bad receiver byte: " + receiver);
        }
        if (this.getState() == SignalingState.TASK) {
            assert (this.responder != null);
            responder = this.responder;
        } else if (this.responders.containsKey(receiver)) {
            responder = this.responders.get(receiver);
        } else {
            throw new ProtocolException("Unknown responder: " + receiver);
        }
        if ("key".equals(messageType)) {
            return this.permanentKey.encrypt(payload, nonce, responder.getPermanentKey());
        }
        return responder.getKeyStore().encrypt(payload, nonce, responder.getSessionKey());
    }

    private short validateResponderId(int id) throws ProtocolException {
        if (id < 0) {
            throw new ProtocolException("Responder id may not be smaller than 0");
        }
        if (id > 255) {
            throw new ProtocolException("Responder id may not be larger than 255");
        }
        return (short)id;
    }

    @Override
    protected void validateSignalingNoncePeerCsn(SignalingChannelNonce nonce) throws ValidationError {
        Responder responder;
        short source = nonce.getSource();
        if (this.isResponderId(source)) {
            responder = this.getResponder(source);
            if (responder == null) {
                throw new ValidationError("Unknown responder: " + source);
            }
        } else {
            throw new ValidationError("Invalid source byte, cannot validate CSN");
        }
        this.validateSignalingNonceCsn(nonce, responder.getCsnPair(), "responder (" + source + ")");
    }

    @Override
    protected void sendClientHello() {
    }

    @Override
    protected void handleServerAuth(Message baseMsg, SignalingChannelNonce nonce) throws ProtocolException {
        InitiatorServerAuth msg;
        try {
            msg = (InitiatorServerAuth)baseMsg;
        }
        catch (ClassCastException e) {
            throw new ProtocolException("Could not cast message to InitiatorServerAuth");
        }
        this.address = 1;
        Cookie repeatedCookie = new Cookie(msg.getYourCookie());
        Cookie ourCookie = this.server.getCookiePair().getOurs();
        if (!repeatedCookie.equals(ourCookie)) {
            this.getLogger().error("Bad repeated cookie in server-auth message");
            this.getLogger().debug("Their response: " + Arrays.toString(repeatedCookie.getBytes()) + ", our cookie: " + Arrays.toString(ourCookie.getBytes()));
            throw new ProtocolException("Bad repeated cookie in server-auth message");
        }
        if (this.expectedServerKey != null) {
            try {
                this.validateSignedKeys(msg.getSignedKeys(), nonce, this.expectedServerKey);
            }
            catch (ValidationError e) {
                this.getLogger().error(e.getMessage());
                throw new ProtocolException("Verification of signed_keys failed", (Throwable)e);
            }
        } else if (msg.getSignedKeys() != null) {
            this.getLogger().warn("Server sent signed keys, but we're not verifying them.");
        }
        for (int number : msg.getResponders()) {
            short id = this.validateResponderId(number);
            this.processNewResponder(id);
        }
        this.getLogger().debug(this.responders.size() + " responder(s) connected.");
        this.server.handshakeState = ServerHandshakeState.DONE;
    }

    @Override
    protected void initPeerHandshake() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onPeerHandshakeMessage(Box box, SignalingChannelNonce nonce) throws ValidationError, SerializationError, InternalException, ConnectionException, SignalingException {
        if (nonce.getDestination() != this.address) {
            throw new ProtocolException("Message destination does not match our address");
        }
        if (nonce.getSource() == 0) {
            byte[] payload;
            try {
                assert (this.server.hasSessionKey());
                payload = this.permanentKey.decrypt(box, this.server.getSessionKey());
            }
            catch (CryptoFailedException | InvalidKeyException e) {
                e.printStackTrace();
                throw new ProtocolException("Could not decrypt server message");
            }
            Message msg = MessageReader.read(payload);
            if (msg instanceof NewResponder) {
                this.getLogger().debug("Received new-responder");
                this.handleNewResponder((NewResponder)msg);
                return;
            } else {
                if (!(msg instanceof SendError)) throw new ProtocolException("Got unexpected server message: " + msg.getType());
                this.getLogger().debug("Received send-error");
                this.handleSendError((SendError)msg);
            }
            return;
        }
        if (!this.isResponderId(nonce.getSource())) throw new ProtocolException("Message source is neither the server nor a responder");
        Responder responder = this.responders.get(nonce.getSource());
        if (responder == null) {
            throw new ProtocolException("Unknown message sender: " + nonce.getSource());
        }
        switch (responder.handshakeState) {
            case NEW: {
                byte[] payload;
                if (this.hasTrustedKey()) {
                    throw new ProtocolException("Handshake state is NEW even though a trusted key is available");
                }
                try {
                    assert (this.authToken != null);
                    payload = this.authToken.decrypt(box);
                }
                catch (CryptoFailedException e) {
                    this.getLogger().warn("Could not decrypt token message");
                    this.dropResponder(responder, 3005);
                    return;
                }
                Message msg = MessageReader.read(payload);
                if (!(msg instanceof Token)) throw new ProtocolException("Expected token message, but got " + msg.getType());
                this.getLogger().debug("Received token");
                this.handleToken((Token)msg, responder);
                return;
            }
            case TOKEN_RECEIVED: {
                byte[] payload;
                try {
                    byte[] peerPublicKey = this.hasTrustedKey() ? this.peerTrustedKey : responder.permanentKey;
                    payload = this.permanentKey.decrypt(box, peerPublicKey);
                }
                catch (CryptoFailedException e) {
                    this.getLogger().warn("Could not decrypt key message");
                    this.dropResponder(responder, 3005);
                    return;
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                    throw new ProtocolException("Invalid key when decrypting key message", (Throwable)e);
                }
                Message msg = MessageReader.read(payload);
                if (!(msg instanceof Key)) throw new ProtocolException("Expected key message, but got " + msg.getType());
                this.getLogger().debug("Received key");
                this.handleKey((Key)msg, responder);
                this.sendKey(responder);
                return;
            }
            case KEY_SENT: {
                byte[] payload;
                try {
                    payload = responder.getKeyStore().decrypt(box, responder.sessionKey);
                }
                catch (CryptoFailedException e) {
                    e.printStackTrace();
                    throw new ProtocolException("Could not decrypt auth message");
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                    throw new ProtocolException("Invalid key when decrypting auth message", (Throwable)e);
                }
                Message msg = MessageReader.read(payload);
                if (!(msg instanceof ResponderAuth)) {
                    throw new ProtocolException("Expected auth message, but got " + msg.getType());
                }
                this.getLogger().debug("Received auth");
                this.handleAuth((ResponderAuth)msg, responder, nonce);
                this.sendAuth(responder, nonce);
                this.responder = responder;
                this.sessionKey = responder.getKeyStore();
                this.responders.remove(responder.getId());
                this.dropResponders(3004);
                this.setState(SignalingState.TASK);
                this.getLogger().info("Peer handshake done");
                this.task.onPeerHandshakeDone();
                return;
            }
            default: {
                throw new InternalException("Unknown or invalid responder handshake state: " + responder.handshakeState.name());
            }
        }
    }

    private void handleNewResponder(NewResponder msg) throws SignalingException {
        short id = this.validateResponderId(msg.getId());
        this.processNewResponder(id);
    }

    private void processNewResponder(short responderId) {
        if (this.responders.containsKey(responderId)) {
            this.responders.remove(responderId);
        }
        Responder responder = new Responder(responderId);
        if (this.hasTrustedKey()) {
            responder.handshakeState = ResponderHandshakeState.TOKEN_RECEIVED;
            responder.setPermanentKey(this.peerTrustedKey);
        }
        this.responders.put(responderId, responder);
    }

    private void handleToken(Token msg, Responder responder) {
        responder.setPermanentKey(msg.getKey());
        responder.handshakeState = ResponderHandshakeState.TOKEN_RECEIVED;
    }

    private void handleKey(Key msg, Responder responder) {
        responder.setSessionKey(msg.getKey());
        responder.handshakeState = ResponderHandshakeState.KEY_RECEIVED;
    }

    private void sendKey(Responder responder) throws SignalingException, ConnectionException {
        Key msg = new Key(responder.getKeyStore().getPublicKey());
        byte[] packet = this.buildPacket(msg, responder);
        this.getLogger().debug("Sending key");
        this.send(packet);
        responder.handshakeState = ResponderHandshakeState.KEY_SENT;
    }

    private void handleAuth(ResponderAuth msg, Responder responder, SignalingChannelNonce nonce) throws SignalingException {
        this.validateRepeatedCookie(responder, msg.getYourCookie());
        Task task = TaskHelper.chooseCommonTask(this.tasks, msg.getTasks());
        if (task == null) {
            throw new SignalingException(3006, "No shared task could be found");
        }
        this.getLogger().info("Task " + task.getName() + " has been selected");
        this.initTask(task, msg.getData().get(task.getName()));
        this.getLogger().debug("Responder 0x" + NaCl.asHex(new int[]{responder.getId()}) + " authenticated");
        responder.getCookiePair().setTheirs(nonce.getCookie());
        responder.handshakeState = ResponderHandshakeState.AUTH_RECEIVED;
    }

    private void sendAuth(Responder responder, SignalingChannelNonce nonce) throws SignalingException, ConnectionException {
        InitiatorAuth msg;
        try {
            HashMap<String, Map<Object, Object>> tasksData = new HashMap<String, Map<Object, Object>>();
            tasksData.put(this.task.getName(), this.task.getData());
            msg = new InitiatorAuth(nonce.getCookieBytes(), this.task.getName(), tasksData);
        }
        catch (ValidationError e) {
            throw new ProtocolException("Invalid task data", (Throwable)e);
        }
        byte[] packet = this.buildPacket(msg, responder);
        this.getLogger().debug("Sending auth");
        this.send(packet);
        responder.handshakeState = ResponderHandshakeState.AUTH_SENT;
    }

    private void dropResponder(Responder responder, @Nullable Integer reason) throws SignalingException, ConnectionException {
        DropResponder msg = new DropResponder(responder.getId(), reason);
        byte[] packet = this.buildPacket(msg, responder);
        this.getLogger().debug("Sending drop-responder " + responder.getId());
        this.send(packet);
        this.responders.remove(responder.getId());
    }

    private void dropResponders(@Nullable Integer reason) throws SignalingException, ConnectionException {
        this.getLogger().debug("Dropping " + this.responders.size() + " other responders");
        for (Responder responder : this.responders.values()) {
            this.dropResponder(responder, reason);
        }
    }

    @Override
    synchronized void handleSendError(short receiver) throws SignalingException {
        if (!this.isResponderId(receiver)) {
            throw new ProtocolException("Outgoing c2c messages must have been sent to a responder");
        }
        boolean notify = false;
        if (this.responder != null) {
            if (this.responder.getId() == receiver) {
                notify = true;
                this.resetConnection(3001);
            } else {
                this.getLogger().warn("Got send-error message for unknown responder " + receiver);
            }
        } else {
            Responder responder = this.responders.get(receiver);
            if (responder == null) {
                this.getLogger().warn("Got send-error message for unknown responder " + receiver);
            } else {
                notify = true;
                this.responders.remove(receiver);
            }
        }
        if (notify) {
            this.salty.events.signalingConnectionLost.notifyHandlers(new SignalingConnectionLostEvent(receiver));
        }
    }

    @Override
    @Nullable
    protected Peer getPeer() {
        return this.responder;
    }

    @Override
    @Nullable
    protected byte[] getPeerSessionKey() {
        if (this.responder != null) {
            return this.responder.sessionKey;
        }
        return null;
    }

    @Nullable
    private Responder getResponder(short id) {
        if (this.getState() == SignalingState.TASK && this.responder != null && this.responder.getId() == id) {
            return this.responder;
        }
        if (this.responders.containsKey(id)) {
            return this.responders.get(id);
        }
        return null;
    }
}

