/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.signaling;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.saltyrtc.client.SaltyRTC;
import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.cookie.Cookie;
import org.saltyrtc.client.events.SignalingConnectionLostEvent;
import org.saltyrtc.client.exceptions.ConnectionException;
import org.saltyrtc.client.exceptions.CryptoFailedException;
import org.saltyrtc.client.exceptions.InternalException;
import org.saltyrtc.client.exceptions.InvalidKeyException;
import org.saltyrtc.client.exceptions.ProtocolException;
import org.saltyrtc.client.exceptions.SerializationError;
import org.saltyrtc.client.exceptions.SignalingException;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.MessageReader;
import org.saltyrtc.client.helpers.TaskHelper;
import org.saltyrtc.client.keystore.AuthToken;
import org.saltyrtc.client.keystore.Box;
import org.saltyrtc.client.keystore.KeyStore;
import org.saltyrtc.client.messages.Message;
import org.saltyrtc.client.messages.c2c.InitiatorAuth;
import org.saltyrtc.client.messages.c2c.Key;
import org.saltyrtc.client.messages.c2c.ResponderAuth;
import org.saltyrtc.client.messages.c2c.Token;
import org.saltyrtc.client.messages.s2c.ClientHello;
import org.saltyrtc.client.messages.s2c.NewInitiator;
import org.saltyrtc.client.messages.s2c.ResponderServerAuth;
import org.saltyrtc.client.messages.s2c.SendError;
import org.saltyrtc.client.nonce.SignalingChannelNonce;
import org.saltyrtc.client.signaling.Initiator;
import org.saltyrtc.client.signaling.Peer;
import org.saltyrtc.client.signaling.Signaling;
import org.saltyrtc.client.signaling.SignalingRole;
import org.saltyrtc.client.signaling.state.InitiatorHandshakeState;
import org.saltyrtc.client.signaling.state.ServerHandshakeState;
import org.saltyrtc.client.signaling.state.SignalingState;
import org.saltyrtc.client.tasks.Task;
import org.saltyrtc.vendor.com.neilalexander.jnacl.NaCl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponderSignaling
extends Signaling {
    @NonNull
    private Initiator initiator;
    @Nullable
    private AuthToken authToken = null;

    @Override
    protected Logger getLogger() {
        return LoggerFactory.getLogger((String)"SaltyRTC.RSignaling");
    }

    public ResponderSignaling(SaltyRTC saltyRTC, String host, int port, KeyStore permanentKey, SSLContext sslContext, @Nullable byte[] initiatorPublicKey, @Nullable byte[] authToken, @Nullable byte[] initiatorTrustedKey, @Nullable byte[] expectedServerKey, Task[] tasks) throws InvalidKeyException {
        super(saltyRTC, host, port, permanentKey, sslContext, initiatorTrustedKey, expectedServerKey, SignalingRole.Responder, tasks);
        if (initiatorTrustedKey != null) {
            if (initiatorPublicKey != null || authToken != null) {
                throw new IllegalArgumentException("Cannot specify both a trusted key and a public key / auth token pair");
            }
            this.initiator = new Initiator(initiatorTrustedKey);
            this.initiator.handshakeState = InitiatorHandshakeState.TOKEN_SENT;
        } else if (initiatorPublicKey != null && authToken != null) {
            this.initiator = new Initiator(initiatorPublicKey);
            this.authToken = new AuthToken(authToken);
        } else {
            throw new IllegalArgumentException("You must specify either a trusted key or a public key / auth token pair");
        }
    }

    @Override
    protected String getWebsocketPath() {
        return NaCl.asHex(this.initiator.getPermanentKey());
    }

    @Override
    protected Box encryptHandshakeDataForPeer(short receiver, String messageType, byte[] payload, byte[] nonce) throws CryptoFailedException, InvalidKeyException, ProtocolException {
        if (this.isResponderId(receiver)) {
            throw new ProtocolException("Responder may not encrypt messages for other responders: " + receiver);
        }
        if (receiver != 1) {
            throw new ProtocolException("Bad receiver byte: " + receiver);
        }
        switch (messageType) {
            case "token": {
                if (this.authToken == null) {
                    throw new ProtocolException("Cannot encrypt token message for peer: Auth token is null");
                }
                return this.authToken.encrypt(payload, nonce);
            }
            case "key": {
                return this.permanentKey.encrypt(payload, nonce, this.initiator.permanentKey);
            }
        }
        byte[] peerSessionKey = this.getPeerSessionKey();
        if (peerSessionKey == null) {
            throw new ProtocolException("Trying to encrypt for peer using session key, but session key is null");
        }
        return this.sessionKey.encrypt(payload, nonce, peerSessionKey);
    }

    @Override
    protected void sendClientHello() throws SignalingException, ConnectionException {
        ClientHello msg = new ClientHello(this.permanentKey.getPublicKey());
        byte[] packet = this.buildPacket(msg, this.server, false);
        this.getLogger().debug("Sending client-hello");
        this.send(packet);
        this.server.handshakeState = ServerHandshakeState.HELLO_SENT;
    }

    @Override
    protected void handleServerAuth(Message baseMsg, SignalingChannelNonce nonce) throws ProtocolException {
        ResponderServerAuth msg;
        try {
            msg = (ResponderServerAuth)baseMsg;
        }
        catch (ClassCastException e) {
            throw new ProtocolException("Could not cast message to ResponderServerAuth");
        }
        if (nonce.getDestination() > 255 || nonce.getDestination() < 2) {
            throw new ProtocolException("Invalid nonce destination: " + nonce.getDestination());
        }
        this.address = nonce.getDestination();
        this.getLogger().debug("Server assigned address 0x" + NaCl.asHex(new int[]{this.address}));
        Cookie repeatedCookie = new Cookie(msg.getYourCookie());
        Cookie ourCookie = this.server.getCookiePair().getOurs();
        if (!repeatedCookie.equals(ourCookie)) {
            this.getLogger().error("Bad repeated cookie in server-auth message");
            this.getLogger().debug("Their response: " + Arrays.toString(repeatedCookie.getBytes()) + ", our cookie: " + Arrays.toString(ourCookie.getBytes()));
            throw new ProtocolException("Bad repeated cookie in server-auth message");
        }
        if (this.expectedServerKey != null) {
            try {
                this.validateSignedKeys(msg.getSignedKeys(), nonce, this.expectedServerKey);
            }
            catch (ValidationError e) {
                this.getLogger().error(e.getMessage());
                throw new ProtocolException("Verification of signed_keys failed", (Throwable)e);
            }
        } else if (msg.getSignedKeys() != null) {
            this.getLogger().warn("Server sent signed keys, but we're not verifying them.");
        }
        this.initiator.setConnected(msg.isInitiatorConnected());
        this.getLogger().debug("Initiator is " + (msg.isInitiatorConnected() ? "" : "not ") + "connected.");
        this.server.handshakeState = ServerHandshakeState.DONE;
    }

    @Override
    protected void initPeerHandshake() throws SignalingException, ConnectionException {
        if (this.initiator.isConnected()) {
            if (!this.hasTrustedKey()) {
                this.sendToken();
            }
            this.sendKey();
        }
    }

    private void sendToken() throws SignalingException, ConnectionException {
        Token msg = new Token(this.permanentKey.getPublicKey());
        byte[] packet = this.buildPacket(msg, this.initiator);
        this.getLogger().debug("Sending token");
        this.send(packet);
        this.initiator.handshakeState = InitiatorHandshakeState.TOKEN_SENT;
    }

    private void sendKey() throws SignalingException, ConnectionException {
        this.sessionKey = new KeyStore();
        Key msg = new Key(this.sessionKey.getPublicKey());
        byte[] packet = this.buildPacket(msg, this.initiator);
        this.getLogger().debug("Sending key");
        this.send(packet);
        this.initiator.handshakeState = InitiatorHandshakeState.KEY_SENT;
    }

    private void handleKey(Key msg) {
        this.initiator.setSessionKey(msg.getKey());
        this.initiator.handshakeState = InitiatorHandshakeState.KEY_RECEIVED;
    }

    private void sendAuth(SignalingChannelNonce nonce) throws SignalingException, ConnectionException {
        ResponderAuth msg;
        if (nonce.getCookie().equals(this.initiator.getCookiePair().getOurs())) {
            throw new ProtocolException("Their cookie and our cookie are the same");
        }
        try {
            HashMap<String, Map<Object, Object>> tasksData = new HashMap<String, Map<Object, Object>>();
            for (Task task : this.tasks) {
                tasksData.put(task.getName(), task.getData());
            }
            msg = new ResponderAuth(nonce.getCookieBytes(), TaskHelper.getTaskNames(this.tasks), tasksData);
        }
        catch (ValidationError e) {
            throw new ProtocolException("Invalid task data", (Throwable)e);
        }
        byte[] packet = this.buildPacket(msg, this.initiator);
        this.getLogger().debug("Sending auth");
        this.send(packet);
        this.initiator.handshakeState = InitiatorHandshakeState.AUTH_SENT;
    }

    private void handleAuth(InitiatorAuth msg, SignalingChannelNonce nonce) throws SignalingException {
        this.validateRepeatedCookie(this.initiator, msg.getYourCookie());
        String taskName = msg.getTask();
        Task selectedTask = null;
        for (Task task : this.tasks) {
            if (!task.getName().equals(taskName)) continue;
            this.getLogger().info("Task " + task.getName() + " has been selected");
            selectedTask = task;
            break;
        }
        if (selectedTask == null) {
            throw new SignalingException(3001, "Initiator selected unknown task");
        }
        this.initTask(selectedTask, msg.getData().get(selectedTask.getName()));
        this.getLogger().debug("Initiator authenticated");
        this.initiator.getCookiePair().setTheirs(nonce.getCookie());
        this.initiator.handshakeState = InitiatorHandshakeState.AUTH_RECEIVED;
    }

    private byte[] decryptInitiatorMessage(Box box) throws ProtocolException {
        switch (this.initiator.handshakeState) {
            case NEW: 
            case TOKEN_SENT: 
            case KEY_RECEIVED: {
                throw new ProtocolException("Received message in " + this.initiator.handshakeState.name() + " state.");
            }
            case KEY_SENT: {
                try {
                    return this.permanentKey.decrypt(box, this.initiator.getPermanentKey());
                }
                catch (CryptoFailedException | InvalidKeyException e) {
                    e.printStackTrace();
                    throw new ProtocolException("Could not decrypt key message");
                }
            }
            case AUTH_SENT: 
            case AUTH_RECEIVED: {
                try {
                    return this.sessionKey.decrypt(box, this.initiator.getSessionKey());
                }
                catch (CryptoFailedException | InvalidKeyException e) {
                    e.printStackTrace();
                    throw new ProtocolException("Could not decrypt message using session key");
                }
            }
        }
        throw new ProtocolException("Invalid handshake state: " + this.initiator.handshakeState.name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onPeerHandshakeMessage(Box box, SignalingChannelNonce nonce) throws ValidationError, SerializationError, InternalException, ConnectionException, SignalingException {
        if (nonce.getDestination() != this.address) {
            throw new ProtocolException("Message destination does not match our address");
        }
        if (nonce.getSource() == 0) {
            byte[] payload;
            try {
                assert (this.server.hasSessionKey());
                payload = this.permanentKey.decrypt(box, this.server.getSessionKey());
            }
            catch (CryptoFailedException | InvalidKeyException e) {
                e.printStackTrace();
                throw new ProtocolException("Could not decrypt server message");
            }
            Message msg = MessageReader.read(payload);
            if (msg instanceof NewInitiator) {
                this.getLogger().debug("Received new-initiator");
                this.handleNewInitiator((NewInitiator)msg);
                return;
            } else {
                if (!(msg instanceof SendError)) throw new ProtocolException("Got unexpected server message: " + msg.getType());
                this.getLogger().debug("Received send-error");
                this.handleSendError((SendError)msg);
            }
            return;
        }
        if (nonce.getSource() != 1) throw new ProtocolException("Message source is neither the server nor the initiator");
        byte[] payload = this.decryptInitiatorMessage(box);
        Message msg = MessageReader.read(payload);
        switch (this.initiator.handshakeState) {
            case KEY_SENT: {
                if (!(msg instanceof Key)) throw new ProtocolException("Expected key message, but got " + msg.getType());
                this.getLogger().debug("Received key");
                this.handleKey((Key)msg);
                this.sendAuth(nonce);
                return;
            }
            case AUTH_SENT: {
                if (!(msg instanceof InitiatorAuth)) {
                    throw new ProtocolException("Expected auth message, but got " + msg.getType());
                }
                this.getLogger().debug("Received auth");
                this.handleAuth((InitiatorAuth)msg, nonce);
                this.setState(SignalingState.TASK);
                this.getLogger().info("Peer handshake done");
                this.task.onPeerHandshakeDone();
                return;
            }
            default: {
                throw new InternalException("Unknown or invalid initiator handshake state");
            }
        }
    }

    private void handleNewInitiator(NewInitiator msg) throws SignalingException, ConnectionException {
        this.initiator = new Initiator(this.initiator.getPermanentKey());
        this.initiator.setConnected(true);
        this.initPeerHandshake();
    }

    @Override
    void handleSendError(short receiver) throws SignalingException {
        if (receiver != 1) {
            throw new ProtocolException("Outgoing c2c messages must have been sent to the initiator");
        }
        this.salty.events.signalingConnectionLost.notifyHandlers(new SignalingConnectionLostEvent(receiver));
        this.resetConnection(3001);
    }

    @Override
    @Nullable
    protected Peer getPeer() {
        return this.initiator;
    }

    @Override
    @Nullable
    protected byte[] getPeerSessionKey() {
        return this.initiator.sessionKey;
    }

    @Override
    protected void validateSignalingNoncePeerCsn(SignalingChannelNonce nonce) throws ValidationError {
        if (nonce.getSource() != 1) {
            throw new ValidationError("Invalid source byte, cannot validate CSN");
        }
        this.validateSignalingNonceCsn(nonce, this.initiator.getCsnPair(), "initiator");
    }
}

