/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.cookie;

import java.util.Arrays;
import org.saltyrtc.client.helpers.RandomHelper;

public class Cookie {
    public static final int COOKIE_LENGTH = 16;
    private byte[] bytes;

    public Cookie() {
        this.bytes = RandomHelper.secureRandomBytes(16);
    }

    public Cookie(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Bad cookie length, must be 16 bytes");
        }
        this.bytes = bytes;
    }

    public Cookie(Cookie cookie) {
        this.bytes = cookie.getBytes();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        return Arrays.equals(this.bytes, cookie.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

