/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.helpers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.saltyrtc.client.exceptions.SerializationError;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.messages.Message;
import org.saltyrtc.client.messages.c2c.Close;
import org.saltyrtc.client.messages.c2c.InitiatorAuth;
import org.saltyrtc.client.messages.c2c.Key;
import org.saltyrtc.client.messages.c2c.ResponderAuth;
import org.saltyrtc.client.messages.c2c.TaskMessage;
import org.saltyrtc.client.messages.c2c.Token;
import org.saltyrtc.client.messages.s2c.ClientAuth;
import org.saltyrtc.client.messages.s2c.ClientHello;
import org.saltyrtc.client.messages.s2c.DropResponder;
import org.saltyrtc.client.messages.s2c.InitiatorServerAuth;
import org.saltyrtc.client.messages.s2c.NewInitiator;
import org.saltyrtc.client.messages.s2c.NewResponder;
import org.saltyrtc.client.messages.s2c.ResponderServerAuth;
import org.saltyrtc.client.messages.s2c.SendError;
import org.saltyrtc.client.messages.s2c.ServerHello;

public class MessageReader {
    public static Message read(byte[] bytes) throws SerializationError, ValidationError {
        return MessageReader.read(bytes, new ArrayList<String>());
    }

    public static Message read(byte[] bytes, List<String> taskTypes) throws SerializationError, ValidationError {
        String type;
        Map map;
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        try {
            map = (Map)objectMapper.readValue(bytes, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new SerializationError("Deserialization failed", e);
        }
        if (!map.containsKey("type")) {
            throw new SerializationError("Message does not contain a type field");
        }
        Object typeObj = map.get("type");
        if (!(typeObj instanceof String)) {
            throw new SerializationError("Message type must be a string");
        }
        switch (type = (String)typeObj) {
            case "server-hello": {
                return new ServerHello(map);
            }
            case "client-hello": {
                return new ClientHello(map);
            }
            case "server-auth": {
                if (map.containsKey("initiator_connected")) {
                    return new ResponderServerAuth(map);
                }
                if (map.containsKey("responders")) {
                    return new InitiatorServerAuth(map);
                }
                throw new ValidationError("Invalid server-auth message");
            }
            case "client-auth": {
                return new ClientAuth(map);
            }
            case "new-initiator": {
                return new NewInitiator(map);
            }
            case "new-responder": {
                return new NewResponder(map);
            }
            case "drop-responder": {
                return new DropResponder(map);
            }
            case "send-error": {
                return new SendError(map);
            }
            case "token": {
                return new Token(map);
            }
            case "key": {
                return new Key(map);
            }
            case "auth": {
                if (map.containsKey("task")) {
                    return new InitiatorAuth(map);
                }
                if (map.containsKey("tasks")) {
                    return new ResponderAuth(map);
                }
                throw new ValidationError("Invalid auth message");
            }
            case "close": {
                return new Close(map);
            }
        }
        if (taskTypes.contains(type)) {
            return new TaskMessage(type, map);
        }
        throw new ValidationError("Unknown message type: " + type);
    }
}

