/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.nonce;

import java.security.SecureRandom;
import org.saltyrtc.client.exceptions.OverflowException;
import org.saltyrtc.client.nonce.CombinedSequenceSnapshot;

public class CombinedSequence {
    public static final long SEQUENCE_NUMBER_MAX = 0x100000000L;
    public static final int OVERFLOW_MAX = 0x100000;
    private long sequenceNumber;
    private int overflow;

    public CombinedSequence() {
        SecureRandom sr = new SecureRandom();
        this.sequenceNumber = sr.nextLong() & 0xFFFFFFFFL;
        this.overflow = 0;
    }

    public CombinedSequence(long sequenceNumber, int overflow) {
        this.sequenceNumber = sequenceNumber;
        this.overflow = overflow;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public long getCombinedSequence() {
        long combined = (long)this.overflow << 32 | this.sequenceNumber;
        assert (combined >= 0L && combined < 0x1000000000000L);
        return combined;
    }

    public synchronized CombinedSequenceSnapshot next() throws OverflowException {
        if (this.sequenceNumber + 1L >= 0x100000000L) {
            this.sequenceNumber = 0L;
            ++this.overflow;
            if (this.overflow >= 0x100000) {
                throw new OverflowException("Overflow number overflow");
            }
        } else {
            ++this.sequenceNumber;
        }
        return new CombinedSequenceSnapshot(this.sequenceNumber, this.overflow);
    }
}

