/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.signaling;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.saltyrtc.chunkedDc.UnsignedHelper;
import org.saltyrtc.client.SaltyRTC;
import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.cookie.Cookie;
import org.saltyrtc.client.events.CloseEvent;
import org.saltyrtc.client.events.SignalingStateChangedEvent;
import org.saltyrtc.client.exceptions.ConnectionException;
import org.saltyrtc.client.exceptions.CryptoFailedException;
import org.saltyrtc.client.exceptions.InternalException;
import org.saltyrtc.client.exceptions.InvalidKeyException;
import org.saltyrtc.client.exceptions.OverflowException;
import org.saltyrtc.client.exceptions.ProtocolException;
import org.saltyrtc.client.exceptions.SerializationError;
import org.saltyrtc.client.exceptions.SignalingException;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.ArrayHelper;
import org.saltyrtc.client.helpers.MessageHistory;
import org.saltyrtc.client.helpers.MessageReader;
import org.saltyrtc.client.keystore.AuthToken;
import org.saltyrtc.client.keystore.Box;
import org.saltyrtc.client.keystore.KeyStore;
import org.saltyrtc.client.messages.Message;
import org.saltyrtc.client.messages.c2c.Close;
import org.saltyrtc.client.messages.c2c.TaskMessage;
import org.saltyrtc.client.messages.s2c.ClientAuth;
import org.saltyrtc.client.messages.s2c.InitiatorServerAuth;
import org.saltyrtc.client.messages.s2c.ResponderServerAuth;
import org.saltyrtc.client.messages.s2c.SendError;
import org.saltyrtc.client.messages.s2c.ServerHello;
import org.saltyrtc.client.nonce.CombinedSequenceSnapshot;
import org.saltyrtc.client.nonce.SignalingChannelNonce;
import org.saltyrtc.client.signaling.CloseCode;
import org.saltyrtc.client.signaling.Peer;
import org.saltyrtc.client.signaling.Server;
import org.saltyrtc.client.signaling.SignalingInterface;
import org.saltyrtc.client.signaling.SignalingRole;
import org.saltyrtc.client.signaling.state.HandoverState;
import org.saltyrtc.client.signaling.state.ServerHandshakeState;
import org.saltyrtc.client.signaling.state.SignalingState;
import org.saltyrtc.client.tasks.Task;
import org.saltyrtc.vendor.com.neilalexander.jnacl.NaCl;
import org.slf4j.Logger;

public abstract class Signaling
implements SignalingInterface {
    static final String SALTYRTC_SUBPROTOCOL = "v0.saltyrtc.org";
    static final short SALTYRTC_WS_CONNECT_TIMEOUT = 2000;
    static final long SALTYRTC_WS_PING_INTERVAL = 20000L;
    static final short SALTYRTC_ADDR_UNKNOWN = 0;
    static final short SALTYRTC_ADDR_SERVER = 0;
    static final short SALTYRTC_ADDR_INITIATOR = 1;
    private final String host;
    private final int port;
    private final SSLContext sslContext;
    private WebSocket ws;
    private SignalingState state = SignalingState.NEW;
    private final HandoverState handoverState = new HandoverState();
    final SaltyRTC salty;
    @NonNull
    Server server;
    @NonNull
    final KeyStore permanentKey;
    KeyStore sessionKey;
    @Nullable
    AuthToken authToken;
    @Nullable
    byte[] peerTrustedKey;
    @Nullable
    byte[] expectedServerKey;
    @NonNull
    private SignalingRole role;
    short address = 0;
    @NonNull
    final Task[] tasks;
    Task task;
    private final MessageHistory history = new MessageHistory(10);

    abstract Logger getLogger();

    public Signaling(SaltyRTC salty, String host, int port, @NonNull KeyStore permanentKey, SSLContext sslContext, @Nullable byte[] peerTrustedKey, @Nullable byte[] expectedServerKey, @NonNull SignalingRole role, @NonNull Task[] tasks) {
        this.salty = salty;
        this.host = host;
        this.port = port;
        this.permanentKey = permanentKey;
        this.sslContext = sslContext;
        this.peerTrustedKey = peerTrustedKey;
        this.expectedServerKey = expectedServerKey;
        this.role = role;
        this.tasks = tasks;
        this.server = new Server();
    }

    @NonNull
    public KeyStore getKeyStore() {
        return this.permanentKey;
    }

    @NonNull
    public byte[] getPublicPermanentKey() {
        return this.permanentKey.getPublicKey();
    }

    @Nullable
    public byte[] getAuthToken() {
        if (this.authToken != null) {
            return this.authToken.getAuthToken();
        }
        return null;
    }

    boolean hasTrustedKey() {
        return this.peerTrustedKey != null;
    }

    @Override
    @NonNull
    public SignalingState getState() {
        return this.state;
    }

    @Override
    public void setState(SignalingState newState) {
        if (this.state != newState) {
            this.state = newState;
            this.salty.events.signalingStateChanged.notifyHandlers(new SignalingStateChangedEvent(newState));
        }
    }

    @Override
    public HandoverState getHandoverState() {
        return this.handoverState;
    }

    @Override
    @NonNull
    public SignalingRole getRole() {
        return this.role;
    }

    public void connect() throws ConnectionException {
        this.getLogger().info("Connecting to SaltyRTC server at " + this.host + ":" + this.port + "...");
        this.resetConnection(null);
        try {
            this.initWebsocket();
        }
        catch (IOException e) {
            throw new ConnectionException("Connecting to WebSocket failed.", e);
        }
        this.connectWebsocket();
    }

    synchronized void disconnect(int reason) {
        this.setState(SignalingState.CLOSING);
        if (this.ws != null) {
            this.getLogger().debug("Disconnecting WebSocket (reason: " + reason + ")");
            this.ws.disconnect(reason);
        }
        this.ws = null;
        if (this.task != null) {
            this.getLogger().debug("Closing task connections (reason: " + reason + ")");
            this.task.close(reason);
        }
        this.setState(SignalingState.CLOSED);
    }

    public void disconnect() {
        this.disconnect(1000);
    }

    @Override
    public void resetConnection(@Nullable Integer reason) {
        if (this.state != SignalingState.NEW) {
            int code = reason != null ? reason : 1000;
            this.disconnect(code);
        }
        this.server = new Server();
        this.handoverState.reset();
        this.setState(SignalingState.NEW);
        this.getLogger().debug("Connection reset");
    }

    abstract String getWebsocketPath();

    private void initWebsocket() throws IOException {
        String baseUrl = "wss://" + this.host + ":" + this.port + "/";
        URI uri = URI.create(baseUrl + this.getWebsocketPath());
        this.getLogger().debug("Initialize WebSocket connection to " + uri);
        WebSocketAdapter listener = new WebSocketAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                1 var3_3 = this;
                synchronized (var3_3) {
                    Signaling.this.getLogger().info("WebSocket connection open");
                    Signaling.this.setState(SignalingState.SERVER_HANDSHAKE);
                }
            }

            public void onConnectError(WebSocket websocket, WebSocketException ex) throws Exception {
                Signaling.this.getLogger().error("Could not connect to websocket: " + ex.getMessage());
                Signaling.this.setState(SignalingState.ERROR);
            }

            public void onTextMessage(WebSocket websocket, String text) throws Exception {
                Signaling.this.getLogger().debug("New string message: " + text);
                Signaling.this.getLogger().error("Protocol error: Received string message, but only binary messages are valid.");
                Signaling.this.resetConnection(3001);
            }

            public synchronized void onBinaryMessage(WebSocket websocket, byte[] binary) {
                Signaling.this.getLogger().debug("New binary message (" + binary.length + " bytes)");
                if (Signaling.this.handoverState.getPeer()) {
                    Signaling.this.getLogger().error("Protocol error: Received WebSocket message from peer even though it has already handed over to task.");
                    Signaling.this.resetConnection(3001);
                    return;
                }
                try {
                    Box box = new Box(ByteBuffer.wrap(binary), 24);
                    SignalingChannelNonce nonce = new SignalingChannelNonce(ByteBuffer.wrap(box.getNonce()));
                    Signaling.this.validateNonce(nonce);
                    switch (Signaling.this.getState()) {
                        case SERVER_HANDSHAKE: {
                            Signaling.this.onServerHandshakeMessage(box, nonce);
                            break;
                        }
                        case PEER_HANDSHAKE: {
                            Signaling.this.onPeerHandshakeMessage(box, nonce);
                            break;
                        }
                        case TASK: {
                            Signaling.this.onSignalingMessage(box, nonce);
                            break;
                        }
                        default: {
                            Signaling.this.getLogger().warn("Received message in " + Signaling.this.getState().name() + " signaling state. Ignoring.");
                            break;
                        }
                    }
                }
                catch (SerializationError | ValidationError e) {
                    Signaling.this.getLogger().error("Protocol error: Invalid incoming message: " + e.getMessage());
                    e.printStackTrace();
                    Signaling.this.resetConnection(3001);
                }
                catch (InternalException e) {
                    Signaling.this.getLogger().error("Internal server error: " + e.getMessage());
                    e.printStackTrace();
                    Signaling.this.resetConnection(3002);
                }
                catch (ConnectionException e) {
                    Signaling.this.getLogger().error("Connection error: " + e.getMessage());
                    e.printStackTrace();
                    Signaling.this.resetConnection(3002);
                }
                catch (SignalingException e) {
                    Signaling.this.getLogger().error("Signaling error: " + CloseCode.explain(e.getCloseCode()));
                    e.printStackTrace();
                    if (Signaling.this.getState() == SignalingState.TASK) {
                        Signaling.this.sendClose(e.getCloseCode());
                    }
                    Signaling.this.resetConnection(e.getCloseCode());
                }
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                String closer = closedByServer ? "server" : "client";
                WebSocketFrame frame = closedByServer ? serverCloseFrame : clientCloseFrame;
                int closeCode = frame.getCloseCode();
                String closeReason = frame.getCloseReason();
                if (closeReason == null) {
                    closeReason = CloseCode.explain(closeCode);
                }
                Signaling.this.getLogger().debug("WebSocket connection closed by " + closer + " with code " + closeCode + ": " + closeReason);
                if (closedByServer) {
                    switch (closeCode) {
                        case 1000: {
                            Signaling.this.getLogger().info("WebSocket closed");
                            break;
                        }
                        case 1001: {
                            Signaling.this.getLogger().error("Server is being shut down");
                            break;
                        }
                        case 1002: {
                            Signaling.this.getLogger().error("No shared sub-protocol could be found");
                            break;
                        }
                        case 3000: {
                            Signaling.this.getLogger().error("Path full (no free responder byte)");
                            break;
                        }
                        case 3001: {
                            break;
                        }
                        case 3002: {
                            Signaling.this.getLogger().error("Internal server error");
                            break;
                        }
                        case 3004: {
                            Signaling.this.getLogger().warn("Dropped by initiator");
                            break;
                        }
                        case 3005: {
                            Signaling.this.getLogger().error("Initiator could not decrypt message");
                            break;
                        }
                        case 3006: {
                            Signaling.this.getLogger().error("No shared task was found");
                        }
                    }
                }
                if (closeCode != 3003) {
                    Signaling.this.salty.events.close.notifyHandlers(new CloseEvent(closeCode));
                    Signaling.this.setState(SignalingState.CLOSED);
                }
            }

            public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
                Signaling.this.getLogger().error("A WebSocket connect error occured: " + cause.getMessage(), (Throwable)cause);
            }

            public void handleCallbackError(WebSocket websocket, Throwable cause) throws Exception {
                Signaling.this.getLogger().error("WebSocket callback error: " + cause);
                cause.printStackTrace();
                Signaling.this.resetConnection(3002);
            }
        };
        this.ws = new WebSocketFactory().setConnectionTimeout(2000).setSSLContext(this.sslContext).createSocket(uri).setPingInterval(20000L).addProtocol(SALTYRTC_SUBPROTOCOL).addListener((WebSocketListener)listener);
    }

    private void connectWebsocket() {
        this.setState(SignalingState.WS_CONNECTING);
        this.ws.connectAsynchronously();
    }

    byte[] buildPacket(Message msg, Peer receiver, boolean encrypt) throws ProtocolException {
        Box box;
        SignalingChannelNonce nonce;
        block7: {
            CombinedSequenceSnapshot csn;
            try {
                csn = receiver.getCsnPair().getOurs().next();
            }
            catch (OverflowException e) {
                throw new ProtocolException("CSN overflow", (Throwable)e);
            }
            nonce = new SignalingChannelNonce(receiver.getCookiePair().getOurs().getBytes(), this.address, receiver.getId(), csn.getOverflow(), csn.getSequenceNumber());
            byte[] nonceBytes = nonce.toBytes();
            byte[] payload = msg.toBytes();
            if (!encrypt) {
                return ArrayHelper.concat(nonceBytes, payload);
            }
            try {
                if (receiver.getId() == 0) {
                    box = this.encryptHandshakeDataForServer(payload, nonceBytes);
                    break block7;
                }
                if (receiver.getId() == 1 || this.isResponderId(receiver.getId())) {
                    box = this.encryptHandshakeDataForPeer(receiver.getId(), msg.getType(), payload, nonceBytes);
                    break block7;
                }
                throw new ProtocolException("Bad receiver byte: " + receiver);
            }
            catch (CryptoFailedException | InvalidKeyException e) {
                throw new ProtocolException("Encrypting failed: " + e.getMessage(), (Throwable)e);
            }
        }
        this.history.store(msg, nonce);
        return box.toBytes();
    }

    byte[] buildPacket(Message msg, Peer receiver) throws ProtocolException {
        return this.buildPacket(msg, receiver, true);
    }

    @Nullable
    abstract Peer getPeer();

    @Nullable
    abstract byte[] getPeerSessionKey();

    private void onServerHandshakeMessage(Box box, SignalingChannelNonce nonce) throws ValidationError, SerializationError, SignalingException, ConnectionException {
        byte[] payload;
        if (this.server.handshakeState == ServerHandshakeState.NEW) {
            payload = box.getData();
        } else {
            try {
                assert (this.server.hasSessionKey());
                payload = this.permanentKey.decrypt(box, this.server.getSessionKey());
            }
            catch (CryptoFailedException | InvalidKeyException e) {
                throw new ProtocolException("Could not decrypt server message", (Throwable)e);
            }
        }
        Message msg = MessageReader.read(payload);
        switch (this.server.handshakeState) {
            case NEW: {
                if (msg instanceof ServerHello) {
                    this.getLogger().debug("Received server-hello");
                    this.handleServerHello((ServerHello)msg, nonce);
                    this.sendClientHello();
                    this.sendClientAuth();
                    break;
                }
                throw new ProtocolException("Expected server-hello message, but got " + msg.getType());
            }
            case HELLO_SENT: {
                throw new ProtocolException("Received " + msg.getType() + " message before sending client-auth");
            }
            case AUTH_SENT: {
                if (msg instanceof InitiatorServerAuth || msg instanceof ResponderServerAuth) {
                    this.getLogger().debug("Received server-auth");
                    this.handleServerAuth(msg, nonce);
                    break;
                }
                throw new ProtocolException("Expected server-auth message, but got " + msg.getType());
            }
            case DONE: {
                throw new SignalingException(3002, "Received server handshake message even though server handshake state is set to DONE");
            }
            default: {
                throw new SignalingException(3002, "Unknown server handshake state");
            }
        }
        if (this.server.handshakeState == ServerHandshakeState.DONE) {
            this.setState(SignalingState.PEER_HANDSHAKE);
            this.getLogger().info("Server handshake done");
            this.initPeerHandshake();
        }
    }

    abstract void onPeerHandshakeMessage(Box var1, SignalingChannelNonce var2) throws ValidationError, SerializationError, InternalException, ConnectionException, SignalingException;

    private void onSignalingMessage(Box box, SignalingChannelNonce nonce) throws SignalingException {
        this.getLogger().debug("Message received");
        if (nonce.getSource() == 0) {
            this.onSignalingServerMessage(box);
        } else {
            byte[] decrypted;
            try {
                decrypted = this.decryptFromPeer(box);
            }
            catch (CryptoFailedException e) {
                this.getLogger().error("Could not decrypt incoming message from peer " + nonce.getSource(), (Throwable)e);
                return;
            }
            this.onSignalingPeerMessage(decrypted);
        }
    }

    private void onSignalingServerMessage(Box box) throws SignalingException {
        Message message;
        try {
            assert (this.server.hasSessionKey());
            byte[] decrypted = this.permanentKey.decrypt(box, this.server.getSessionKey());
            message = MessageReader.read(decrypted);
        }
        catch (CryptoFailedException e) {
            this.getLogger().error("Could not decrypt incoming message from server", (Throwable)e);
            return;
        }
        catch (InvalidKeyException e) {
            this.getLogger().error("InvalidKeyException while processing incoming message from server", (Throwable)e);
            return;
        }
        catch (SerializationError | ValidationError e) {
            this.getLogger().error("Received invalid message from server", (Throwable)e);
            return;
        }
        if (message instanceof SendError) {
            this.handleSendError((SendError)message);
        } else {
            this.getLogger().error("Invalid server message type: " + message.getType());
        }
    }

    @Override
    public void onSignalingPeerMessage(byte[] decryptedBytes) {
        Message message;
        try {
            message = MessageReader.read(decryptedBytes, this.task.getSupportedMessageTypes());
        }
        catch (SerializationError | ValidationError e) {
            this.getLogger().error("Received invalid message from peer", (Throwable)e);
            return;
        }
        if (message instanceof Close) {
            this.getLogger().debug("Received close");
            this.handleClose((Close)message);
        } else if (message instanceof TaskMessage) {
            this.task.onTaskMessage((TaskMessage)message);
        } else {
            this.getLogger().error("Received message with invalid type from peer");
        }
    }

    private void handleServerHello(ServerHello msg, SignalingChannelNonce nonce) throws ProtocolException {
        this.server.setSessionKey(msg.getKey());
        this.server.getCookiePair().setTheirs(nonce.getCookie());
    }

    abstract void sendClientHello() throws SignalingException, ConnectionException;

    private void sendClientAuth() throws SignalingException, ConnectionException {
        List<String> subprotocols = Collections.singletonList(SALTYRTC_SUBPROTOCOL);
        ClientAuth msg = new ClientAuth(this.server.getCookiePair().getTheirs().getBytes(), subprotocols);
        byte[] packet = this.buildPacket(msg, this.server);
        this.getLogger().debug("Sending client-auth");
        this.send(packet, msg);
        this.server.handshakeState = ServerHandshakeState.AUTH_SENT;
    }

    abstract void handleServerAuth(Message var1, SignalingChannelNonce var2) throws ProtocolException;

    void validateSignedKeys(@Nullable byte[] signedKeys, @NonNull SignalingChannelNonce nonce, @NonNull byte[] expectedServerKey) throws ValidationError {
        byte[] decrypted;
        assert (this.server.hasSessionKey());
        if (signedKeys == null) {
            throw new ValidationError("Server did not send signed_keys in server-auth message");
        }
        Box box = new Box(nonce.toBytes(), signedKeys);
        try {
            this.getLogger().debug("Expected server key is " + NaCl.asHex(expectedServerKey));
            this.getLogger().debug("Server session key is " + NaCl.asHex(this.server.getSessionKey()));
            decrypted = this.permanentKey.decrypt(box, expectedServerKey);
        }
        catch (CryptoFailedException e) {
            throw new ValidationError("Could not decrypt signed_keys in server-auth message", e);
        }
        catch (InvalidKeyException e) {
            throw new ValidationError("Invalid key when trying to decrypt signed_keys in server-auth message", e);
        }
        byte[] expected = ArrayHelper.concat(this.server.getSessionKey(), this.permanentKey.getPublicKey());
        if (!Arrays.equals(decrypted, expected)) {
            throw new ValidationError("Decrypted signed_keys in server-auth message is invalid");
        }
    }

    abstract void initPeerHandshake() throws SignalingException, ConnectionException;

    void initTask(Task task, Map<Object, Object> data) throws ProtocolException {
        try {
            task.init(this, data);
        }
        catch (ValidationError e) {
            e.printStackTrace();
            throw new ProtocolException("Peer sent invalid task data", (Throwable)e);
        }
        this.task = task;
    }

    @Nullable
    public Task getTask() {
        return this.task;
    }

    @Override
    public void sendClose(int reason) {
        byte[] packet;
        Close msg = new Close(reason);
        try {
            packet = this.buildPacket(msg, this.getPeer());
        }
        catch (NullPointerException | ProtocolException e) {
            e.printStackTrace();
            this.getLogger().error("Could not build close message");
            return;
        }
        this.getLogger().debug("Sending close");
        try {
            this.send(packet, msg);
        }
        catch (ConnectionException | SignalingException e) {
            e.printStackTrace();
            this.getLogger().error("Could not send close message");
        }
    }

    boolean isResponderId(short receiver) {
        return receiver >= 2 && receiver <= 255;
    }

    private void validateNonce(SignalingChannelNonce nonce) throws ValidationError, SignalingException {
        this.validateNonceSource(nonce);
        this.validateNonceDestination(nonce);
        this.validateNonceCsn(nonce);
        this.validateNonceCookie(nonce);
    }

    private void validateNonceSource(SignalingChannelNonce nonce) throws ValidationError {
        switch (this.getState()) {
            case SERVER_HANDSHAKE: {
                if (nonce.getSource() == 0) break;
                throw new ValidationError("Received message during server handshake with invalid sender address (" + nonce.getSource() + " != " + 0 + ")");
            }
            case PEER_HANDSHAKE: {
                if (nonce.getSource() == 0) break;
                switch (this.role) {
                    case Initiator: {
                        if (this.isResponderId(nonce.getSource())) break;
                        throw new ValidationError("Initiator peer message does not come from a valid responder address: " + nonce.getSource());
                    }
                    case Responder: {
                        if (nonce.getSource() == 1) break;
                        throw new ValidationError("Responder peer message does not come from intitiator (1), but from " + nonce.getSource());
                    }
                }
                break;
            }
            case TASK: {
                Peer peer = this.getPeer();
                assert (peer != null);
                if (nonce.getSource() == peer.getId()) break;
                throw new ValidationError("Received message with invalid sender address (" + nonce.getSource() + " != " + peer.getId() + ")");
            }
            default: {
                throw new ValidationError("Cannot validate message nonce in signaling state " + (Object)((Object)this.getState()));
            }
        }
    }

    private void validateNonceDestination(SignalingChannelNonce nonce) throws ValidationError {
        Short expected = null;
        if (this.getState() == SignalingState.SERVER_HANDSHAKE) {
            switch (this.server.handshakeState) {
                case NEW: 
                case HELLO_SENT: {
                    expected = 0;
                    break;
                }
                case AUTH_SENT: {
                    if (this.role == SignalingRole.Initiator) {
                        expected = 1;
                        break;
                    }
                    if (this.isResponderId(nonce.getDestination())) break;
                    throw new ValidationError("Received message during server handshake with invalid receiver address (" + nonce.getDestination() + " is not a valid responder id)");
                }
                case DONE: {
                    expected = this.address;
                }
            }
        } else if (this.getState() == SignalingState.PEER_HANDSHAKE || this.getState() == SignalingState.TASK) {
            expected = this.address;
        } else {
            throw new ValidationError("Cannot validate message nonce in signaling state " + (Object)((Object)this.getState()));
        }
        if (expected != null && nonce.getDestination() != expected.shortValue()) {
            throw new ValidationError("Received message during server handshake with invalid receiver address (" + nonce.getDestination() + " != " + expected + ")");
        }
    }

    @Nullable
    abstract Peer getPeerWithId(short var1) throws SignalingException;

    private void validateNonceCsn(SignalingChannelNonce nonce) throws ValidationError, SignalingException {
        Peer peer = this.getPeerWithId(nonce.getSource());
        if (peer == null) {
            throw new ProtocolException("Could not find peer " + nonce.getSource());
        }
        if (!peer.getCsnPair().hasTheirs()) {
            if (nonce.getOverflow() != 0) {
                throw new ValidationError("First message from " + peer.getName() + " must have set the overflow number to 0");
            }
            peer.getCsnPair().setTheirs(nonce.getCombinedSequence());
        } else {
            long previous = peer.getCsnPair().getTheirs();
            long current = nonce.getCombinedSequence();
            if (current < previous) {
                throw new ValidationError(peer.getName() + " CSN is lower than last time");
            }
            if (current == previous) {
                throw new ValidationError(peer.getName() + " CSN hasn't been incremented");
            }
            peer.getCsnPair().setTheirs(current);
        }
    }

    private void validateNonceCookie(SignalingChannelNonce nonce) throws ValidationError, SignalingException {
        Peer peer = this.getPeerWithId(nonce.getSource());
        if (peer != null && peer.getCookiePair().hasTheirs() && !nonce.getCookie().equals(peer.getCookiePair().getTheirs())) {
            throw new ValidationError(peer.getName() + " cookie changed");
        }
    }

    void validateRepeatedCookie(Peer peer, byte[] theirCookie) throws ProtocolException {
        Cookie repeatedCookie = new Cookie(theirCookie);
        Cookie ourCookie = peer.getCookiePair().getOurs();
        if (!repeatedCookie.equals(ourCookie)) {
            this.getLogger().debug("Peer repeated cookie: " + Arrays.toString(theirCookie));
            this.getLogger().debug("Our cookie: " + Arrays.toString(ourCookie.getBytes()));
            throw new ProtocolException("Peer repeated cookie does not match our cookie");
        }
    }

    private Box encryptHandshakeDataForServer(byte[] payload, byte[] nonce) throws CryptoFailedException, InvalidKeyException {
        assert (this.server.hasSessionKey());
        return this.permanentKey.encrypt(payload, nonce, this.server.getSessionKey());
    }

    abstract Box encryptHandshakeDataForPeer(short var1, String var2, byte[] var3, byte[] var4) throws CryptoFailedException, InvalidKeyException, ProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(@NonNull byte[] payload, @NonNull Message msg) throws ConnectionException, SignalingException {
        SignalingState state = this.getState();
        if (state != SignalingState.TASK && state != SignalingState.SERVER_HANDSHAKE && state != SignalingState.PEER_HANDSHAKE) {
            this.getLogger().error("Trying to send message, but connection state is " + (Object)((Object)this.getState()));
            throw new ConnectionException("SaltyRTC instance is not connected");
        }
        Signaling signaling = this;
        synchronized (signaling) {
            if (!this.handoverState.getLocal()) {
                this.ws.sendBinary(payload);
            } else {
                this.task.sendSignalingMessage(msg.toBytes());
            }
        }
    }

    @Override
    public void sendTaskMessage(TaskMessage msg) throws SignalingException, ConnectionException {
        Peer receiver = this.getPeer();
        if (receiver == null) {
            throw new SignalingException(3002, "No peer address could be found");
        }
        byte[] packet = this.buildPacket(msg, receiver);
        this.send(packet, msg);
    }

    private void handleClose(Close msg) {
        Integer closeCode = msg.getReason();
        this.getLogger().warn("Received close message. Reason: " + CloseCode.explain(closeCode));
        this.task.close(closeCode);
        this.resetConnection(1001);
    }

    abstract void handleSendError(short var1) throws SignalingException;

    void handleSendError(SendError msg) throws SignalingException {
        byte[] id = msg.getId();
        String idString = NaCl.asHex(id);
        ByteBuffer buf = ByteBuffer.wrap(id);
        short source = UnsignedHelper.readUnsignedByte((byte)buf.get());
        short destination = UnsignedHelper.readUnsignedByte((byte)buf.get());
        if (source != this.address) {
            throw new ProtocolException("Received send-error message for a message not sent by us!");
        }
        Message message = this.history.find(id);
        if (message != null) {
            this.getLogger().warn("SendError: Could not send " + message.getType() + " message " + idString);
        } else {
            this.getLogger().warn("SendError: Could not send unknown message: " + idString);
        }
        this.handleSendError(destination);
    }

    @Override
    public Box encryptForPeer(@NonNull byte[] data, @NonNull byte[] nonce) throws CryptoFailedException {
        try {
            return this.sessionKey.encrypt(data, nonce, this.getPeerSessionKey());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            if (this.getState() == SignalingState.TASK) {
                this.sendClose(3002);
            }
            this.resetConnection(3002);
            return null;
        }
    }

    @Override
    public byte[] decryptFromPeer(Box box) throws CryptoFailedException {
        try {
            return this.sessionKey.decrypt(box, this.getPeerSessionKey());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            if (this.getState() == SignalingState.TASK) {
                this.sendClose(3002);
            }
            this.resetConnection(3002);
            return null;
        }
    }
}

