/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.vendor.com.neilalexander.jnacl;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Formatter;
import org.saltyrtc.vendor.com.neilalexander.jnacl.crypto.curve25519xsalsa20poly1305;
import org.saltyrtc.vendor.com.neilalexander.jnacl.crypto.xsalsa20;
import org.saltyrtc.vendor.com.neilalexander.jnacl.crypto.xsalsa20poly1305;

public class NaCl {
    public static final int PUBLICKEYBYTES = 32;
    public static final int SECRETKEYBYTES = 32;
    public static final int BEFORENMBYTES = 32;
    public static final int NONCEBYTES = 24;
    public static final int ZEROBYTES = 32;
    public static final int BOXZEROBYTES = 16;
    public static final int BOXOVERHEAD = 16;
    public static final int SYMMKEYBYTES = 32;
    public static final int STREAMKEYBYTES = 32;
    private final byte[] precomputed = new byte[32];

    public NaCl(byte[] privatekey, byte[] publickey) {
        if (privatekey.length != 32) {
            throw new Error("Invalid private key length");
        }
        if (publickey.length != 32) {
            throw new Error("Invalid public key length");
        }
        curve25519xsalsa20poly1305.crypto_box_beforenm(this.precomputed, publickey, privatekey);
    }

    public NaCl(String privatekey, String publickey) {
        this(NaCl.getBinary(privatekey), NaCl.getBinary(publickey));
    }

    public byte[] encrypt(byte[] input, byte[] nonce) {
        return this.encrypt(input, input.length, nonce);
    }

    public byte[] encrypt(byte[] input, int inputlength, byte[] nonce) {
        if (nonce.length != 24) {
            throw new Error("Invalid nonce length");
        }
        byte[] output = new byte[inputlength + 16];
        curve25519xsalsa20poly1305.crypto_box_afternm_nopad(output, 0, input, 0, input.length, nonce, this.precomputed);
        return output;
    }

    public byte[] decrypt(byte[] input, byte[] nonce) {
        return this.decrypt(input, input.length, nonce);
    }

    public byte[] decrypt(byte[] input, int inputlength, byte[] nonce) {
        if (nonce.length != 24) {
            throw new Error("Invalid nonce length");
        }
        if (inputlength < 16) {
            return null;
        }
        byte[] output = new byte[inputlength - 16];
        if (curve25519xsalsa20poly1305.crypto_box_open_afternm_nopad(output, 0, input, 0, input.length, nonce, this.precomputed) != 0) {
            return null;
        }
        return output;
    }

    public static void genkeypair(byte[] publickey, byte[] privatekey) {
        NaCl.genkeypair(publickey, privatekey, null);
    }

    public static void genkeypair(byte[] publickey, byte[] privatekey, byte[] seed) {
        SecureRandom random = new SecureRandom();
        random.nextBytes(privatekey);
        if (seed != null) {
            if (seed.length != 32) {
                throw new Error("Invalid seed length");
            }
            for (int i = 0; i < 32; ++i) {
                int n = i;
                privatekey[n] = (byte)(privatekey[n] ^ seed[i]);
            }
        }
        curve25519xsalsa20poly1305.crypto_box_getpublickey(publickey, privatekey);
    }

    public static byte[] derivePublicKey(byte[] privatekey) {
        if (privatekey.length != 32) {
            throw new Error("Invalid private key length");
        }
        byte[] publickey = new byte[32];
        curve25519xsalsa20poly1305.crypto_box_getpublickey(publickey, privatekey);
        return publickey;
    }

    public static byte[] symmetricEncryptData(byte[] input, byte[] key, byte[] nonce) {
        if (key.length != 32) {
            throw new Error("Invalid symmetric key length");
        }
        if (nonce.length != 24) {
            throw new Error("Invalid nonce length");
        }
        byte[] output = new byte[input.length + 16];
        xsalsa20poly1305.crypto_secretbox_nopad(output, 0, input, 0, input.length, nonce, key);
        return output;
    }

    public static void symmetricEncryptDataInplace(byte[] io, byte[] key, byte[] nonce) {
        if (key.length != 32) {
            throw new Error("Invalid symmetric key length");
        }
        if (nonce.length != 24) {
            throw new Error("Invalid nonce length");
        }
        if (io.length < 16) {
            throw new Error("Invalid I/O length");
        }
        xsalsa20poly1305.crypto_secretbox_nopad(io, 0, io, 16, io.length - 16, nonce, key);
    }

    public static byte[] symmetricDecryptData(byte[] input, byte[] key, byte[] nonce) {
        if (key.length != 32) {
            throw new Error("Invalid symmetric key length");
        }
        if (nonce.length != 24) {
            throw new Error("Invalid nonce length");
        }
        byte[] output = new byte[input.length - 16];
        if (xsalsa20poly1305.crypto_secretbox_open_nopad(output, 0, input, 0, input.length, nonce, key) != 0) {
            return null;
        }
        return output;
    }

    public static boolean symmetricDecryptDataInplace(byte[] io, byte[] key, byte[] nonce) {
        if (key.length != 32) {
            throw new Error("Invalid symmetric key length");
        }
        if (nonce.length != 24) {
            throw new Error("Invalid nonce length");
        }
        if (io.length < 16) {
            throw new Error("Invalid I/O length");
        }
        if (xsalsa20poly1305.crypto_secretbox_open_nopad(io, 0, io, 0, io.length, nonce, key) != 0) {
            return false;
        }
        for (int i = io.length - 16; i < io.length; ++i) {
            io[i] = 0;
        }
        return true;
    }

    public static byte[] streamCryptData(byte[] input, byte[] key, byte[] nonce) {
        if (key.length != 32) {
            throw new Error("Invalid symmetric key length");
        }
        byte[] output = new byte[input.length];
        xsalsa20.crypto_stream_xor(output, input, input.length, nonce, key);
        return output;
    }

    public static byte[] getBinary(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String asHex(byte[] buf) {
        Formatter formatter = new Formatter();
        for (byte b : buf) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public static String asHex(int[] buf) {
        Formatter formatter = new Formatter();
        for (int b : buf) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public static void selfTest() {
        byte[] alicepk = new byte[]{-123, 32, -16, 9, -119, 48, -89, 84, 116, -117, 125, -36, -76, 62, -9, 90, 13, -65, 58, 13, 38, 56, 26, -12, -21, -92, -87, -114, -86, -101, 78, 106};
        byte[] alicesk = new byte[]{119, 7, 109, 10, 115, 24, -91, 125, 60, 22, -63, 114, 81, -78, 102, 69, -33, 76, 47, -121, -21, -64, -103, 42, -79, 119, -5, -91, 29, -71, 44, 42};
        byte[] bobpk = new byte[]{-34, -98, -37, 125, 123, 125, -63, -76, -45, 91, 97, -62, -20, -28, 53, 55, 63, -125, 67, -56, 91, 120, 103, 77, -83, -4, 126, 20, 111, -120, 43, 79};
        byte[] bobsk = new byte[]{93, -85, 8, 126, 98, 74, -118, 75, 121, -31, 127, -117, -125, -128, 14, -26, 111, 59, -79, 41, 38, 24, -74, -3, 28, 47, -117, 39, -1, -120, -32, -21};
        byte[] nonce = new byte[]{105, 105, 110, -23, 85, -74, 43, 115, -51, 98, -67, -88, 117, -4, 115, -42, -126, 25, -32, 3, 107, 122, 11, 55};
        byte[] m = new byte[]{-66, 7, 95, -59, 60, -127, -14, -43, -49, 20, 19, 22, -21, -21, 12, 123, 82, 40, -59, 42, 76, 98, -53, -44, 75, 102, -124, -101, 100, 36, 79, -4, -27, -20, -70, -81, 51, -67, 117, 26, 26, -57, 40, -44, 94, 108, 97, 41, 108, -36, 60, 1, 35, 53, 97, -12, 29, -74, 108, -50, 49, 74, -37, 49, 14, 59, -24, 37, 12, 70, -16, 109, -50, -22, 58, 127, -95, 52, -128, 87, -30, -10, 85, 106, -42, -79, 49, -118, 2, 74, -125, -113, 33, -81, 31, -34, 4, -119, 119, -21, 72, -11, -97, -3, 73, 36, -54, 28, 96, -112, 46, 82, -16, -96, -119, -68, 118, -119, 112, 64, -32, -126, -7, 55, 118, 56, 72, 100, 94, 7, 5};
        byte[] c_expected = new byte[]{-13, -1, -57, 112, 63, -108, 0, -27, 42, 125, -5, 75, 61, 51, 5, -39, -114, -103, 59, -97, 72, 104, 18, 115, -62, -106, 80, -70, 50, -4, 118, -50, 72, 51, 46, -89, 22, 77, -106, -92, 71, 111, -72, -59, 49, -95, 24, 106, -64, -33, -63, 124, -104, -36, -24, 123, 77, -89, -16, 17, -20, 72, -55, 114, 113, -46, -62, 15, -101, -110, -113, -30, 39, 13, 111, -72, 99, -43, 23, 56, -76, -114, -18, -29, 20, -89, -52, -118, -71, 50, 22, 69, 72, -27, 38, -82, -112, 34, 67, 104, 81, 122, -49, -22, -67, 107, -77, 115, 43, -64, -23, -38, -103, -125, 43, 97, -54, 1, -74, -34, 86, 36, 74, -98, -120, -43, -7, -77, 121, 115, -10, 34, -92, 61, 20, -90, 89, -101, 31, 101, 76, -76, 90, 116, -29, 85, -91};
        NaCl nacl = new NaCl(alicesk, bobpk);
        byte[] c = nacl.encrypt(m, nonce);
        if (!Arrays.equals(c, c_expected)) {
            throw new RuntimeException("Crypto self-test failed (1)");
        }
        nacl = new NaCl(bobsk, alicepk);
        byte[] p_d = nacl.decrypt(c, nonce);
        if (!Arrays.equals(p_d, m)) {
            throw new RuntimeException("Crypto self-test failed (2)");
        }
    }

    static {
        NaCl.selfTest();
    }
}

