/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client;

import javax.net.ssl.SSLContext;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.events.ApplicationDataEvent;
import org.saltyrtc.client.events.CloseEvent;
import org.saltyrtc.client.events.EventRegistry;
import org.saltyrtc.client.events.HandoverEvent;
import org.saltyrtc.client.events.SignalingConnectionLostEvent;
import org.saltyrtc.client.events.SignalingStateChangedEvent;
import org.saltyrtc.client.exceptions.ConnectionException;
import org.saltyrtc.client.exceptions.InvalidKeyException;
import org.saltyrtc.client.exceptions.InvalidStateException;
import org.saltyrtc.client.keystore.KeyStore;
import org.saltyrtc.client.messages.c2c.Application;
import org.saltyrtc.client.signaling.InitiatorSignaling;
import org.saltyrtc.client.signaling.ResponderSignaling;
import org.saltyrtc.client.signaling.Signaling;
import org.saltyrtc.client.signaling.SignalingRole;
import org.saltyrtc.client.signaling.state.SignalingState;
import org.saltyrtc.client.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaltyRTC {
    private static final Logger LOG = LoggerFactory.getLogger((String)"SaltyRTC");
    private boolean debug = false;
    private Signaling signaling;
    public final Events events = new Events();

    SaltyRTC(KeyStore permanentKey, String host, int port, SSLContext sslContext, @Nullable byte[] serverKey, Task[] tasks, int pingInterval) throws InvalidKeyException {
        this.signaling = new InitiatorSignaling(this, host, port, permanentKey, sslContext, null, serverKey, tasks, pingInterval);
    }

    SaltyRTC(KeyStore permanentKey, String host, int port, SSLContext sslContext, byte[] initiatorPublicKey, byte[] authToken, @Nullable byte[] serverKey, Task[] tasks, int pingInterval) throws InvalidKeyException {
        this.signaling = new ResponderSignaling(this, host, port, permanentKey, sslContext, initiatorPublicKey, authToken, null, serverKey, tasks, pingInterval);
    }

    SaltyRTC(KeyStore permanentKey, String host, int port, SSLContext sslContext, byte[] peerTrustedKey, @Nullable byte[] serverKey, Task[] tasks, int pingInterval, SignalingRole role) throws InvalidKeyException {
        switch (role) {
            case Initiator: {
                this.signaling = new InitiatorSignaling(this, host, port, permanentKey, sslContext, peerTrustedKey, serverKey, tasks, pingInterval);
                break;
            }
            case Responder: {
                this.signaling = new ResponderSignaling(this, host, port, permanentKey, sslContext, null, null, peerTrustedKey, serverKey, tasks, pingInterval);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid role: " + (Object)((Object)role));
            }
        }
    }

    public KeyStore getKeyStore() {
        return this.signaling.getKeyStore();
    }

    public byte[] getPublicPermanentKey() {
        return this.signaling.getPublicPermanentKey();
    }

    public byte[] getAuthToken() {
        return this.signaling.getAuthToken();
    }

    public SignalingState getSignalingState() {
        return this.signaling.getState();
    }

    @Nullable
    public Task getTask() {
        return this.signaling.getTask();
    }

    public void connect() throws ConnectionException {
        this.signaling.connect();
    }

    public void sendApplicationMessage(Object data) throws ConnectionException, InvalidStateException {
        if (this.signaling.getState() != SignalingState.TASK) {
            throw new InvalidStateException("Application messages can only be sent in TASK state, not in " + this.signaling.getState().name());
        }
        this.signaling.sendApplication(new Application(data));
    }

    public void disconnect() {
        this.signaling.disconnect();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public static class Events {
        public final EventRegistry<SignalingStateChangedEvent> signalingStateChanged = new EventRegistry();
        public final EventRegistry<HandoverEvent> handover = new EventRegistry();
        public final EventRegistry<ApplicationDataEvent> applicationData = new EventRegistry();
        public final EventRegistry<SignalingConnectionLostEvent> signalingConnectionLost = new EventRegistry();
        public final EventRegistry<CloseEvent> close = new EventRegistry();

        public void clearAll() {
            this.signalingStateChanged.clear();
            this.handover.clear();
            this.applicationData.clear();
            this.signalingConnectionLost.clear();
            this.close.clear();
        }
    }
}

