/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client;

import javax.net.ssl.SSLContext;
import org.saltyrtc.client.SaltyRTC;
import org.saltyrtc.client.SaltyRTCServerInfo;
import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.exceptions.InvalidBuilderStateException;
import org.saltyrtc.client.exceptions.InvalidKeyException;
import org.saltyrtc.client.helpers.HexHelper;
import org.saltyrtc.client.keystore.KeyStore;
import org.saltyrtc.client.signaling.SignalingRole;
import org.saltyrtc.client.tasks.Task;
import org.saltyrtc.vendor.com.neilalexander.jnacl.NaCl;

public class SaltyRTCBuilder {
    private boolean hasKeyStore = false;
    private boolean hasConnectionInfo = false;
    private boolean hasInitiatorInfo = false;
    private boolean hasTrustedPeerKey = false;
    private boolean hasTasks = false;
    private KeyStore keyStore;
    private String host;
    private Integer port;
    private SSLContext sslContext;
    private SaltyRTCServerInfo serverInfo;
    private byte[] initiatorPublicKey;
    private byte[] authToken;
    private byte[] peerTrustedKey;
    private byte[] serverKey;
    private Task[] tasks;
    private int pingInterval = 0;

    private void validateHost(String host) {
        if (host.endsWith("/")) {
            throw new IllegalArgumentException("SaltyRTC host may not end with a slash");
        }
        if (host.contains("//")) {
            throw new IllegalArgumentException("SaltyRTC host should not contain protocol");
        }
    }

    private void requireKeyStore() throws InvalidBuilderStateException {
        if (!this.hasKeyStore) {
            throw new InvalidBuilderStateException("Keys not set yet. Please call .withKeyStore method first.");
        }
    }

    private void requireConnectionInfo() throws InvalidBuilderStateException {
        if (!this.hasConnectionInfo) {
            throw new InvalidBuilderStateException("Connection info not set yet. Please call .connectTo method first.");
        }
    }

    private void requireTasks() throws InvalidBuilderStateException {
        if (!this.hasTasks) {
            throw new InvalidBuilderStateException("Tasks not set yet. Please call .usingTasks method first.");
        }
    }

    private void requireInitiatorInfo() throws InvalidBuilderStateException {
        if (!this.hasInitiatorInfo) {
            throw new InvalidBuilderStateException("Initiator info not set yet. Please call .initiatorInfo method first.");
        }
    }

    public SaltyRTCBuilder connectTo(String host, int port, SSLContext sslContext) {
        this.validateHost(host);
        this.host = host;
        this.port = port;
        this.sslContext = sslContext;
        this.hasConnectionInfo = true;
        return this;
    }

    public SaltyRTCBuilder connectTo(SaltyRTCServerInfo serverInfo) {
        this.serverInfo = serverInfo;
        this.hasConnectionInfo = true;
        return this;
    }

    public SaltyRTCBuilder withKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        this.hasKeyStore = true;
        return this;
    }

    public SaltyRTCBuilder withTrustedPeerKey(byte[] peerTrustedKey) {
        this.peerTrustedKey = peerTrustedKey;
        this.hasTrustedPeerKey = true;
        return this;
    }

    public SaltyRTCBuilder withTrustedPeerKey(String peerTrustedKeyHex) {
        return this.withTrustedPeerKey(HexHelper.hexStringToByteArray(peerTrustedKeyHex));
    }

    public SaltyRTCBuilder withServerKey(byte[] serverKey) {
        this.serverKey = serverKey;
        return this;
    }

    public SaltyRTCBuilder withServerKey(String serverKeyHex) {
        return this.withServerKey(HexHelper.hexStringToByteArray(serverKeyHex));
    }

    public SaltyRTCBuilder withPingInterval(int interval) {
        if (interval < 0) {
            throw new IllegalArgumentException("Ping interval may not be negative");
        }
        this.pingInterval = interval;
        return this;
    }

    public SaltyRTCBuilder initiatorInfo(byte[] initiatorPublicKey, byte[] authToken) {
        this.initiatorPublicKey = initiatorPublicKey;
        this.authToken = authToken;
        this.hasInitiatorInfo = true;
        return this;
    }

    public SaltyRTCBuilder initiatorInfo(String initiatorPublicKeyHex, String authTokenHex) {
        return this.initiatorInfo(HexHelper.hexStringToByteArray(initiatorPublicKeyHex), HexHelper.hexStringToByteArray(authTokenHex));
    }

    public SaltyRTCBuilder usingTasks(Task[] tasks) {
        if (tasks.length < 1) {
            throw new IllegalArgumentException("You must specify at least 1 task");
        }
        this.tasks = tasks;
        this.hasTasks = true;
        return this;
    }

    private void processServerInfo(@NonNull SaltyRTCServerInfo serverInfo, byte[] publicKey) {
        String hexPublicKey = NaCl.asHex(publicKey);
        this.host = serverInfo.getHost(hexPublicKey);
        this.port = serverInfo.getPort(hexPublicKey);
        this.sslContext = serverInfo.getSSLContext(hexPublicKey);
    }

    public SaltyRTC asInitiator() throws InvalidBuilderStateException, InvalidKeyException {
        this.requireKeyStore();
        this.requireConnectionInfo();
        this.requireTasks();
        if (this.serverInfo != null) {
            this.processServerInfo(this.serverInfo, this.keyStore.getPublicKey());
        }
        if (this.hasTrustedPeerKey) {
            return new SaltyRTC(this.keyStore, this.host, (int)this.port, this.sslContext, this.peerTrustedKey, this.serverKey, this.tasks, this.pingInterval, SignalingRole.Initiator);
        }
        return new SaltyRTC(this.keyStore, this.host, this.port, this.sslContext, this.serverKey, this.tasks, this.pingInterval);
    }

    public SaltyRTC asResponder() throws InvalidBuilderStateException, InvalidKeyException {
        this.requireKeyStore();
        this.requireConnectionInfo();
        this.requireTasks();
        if (this.hasTrustedPeerKey) {
            if (this.serverInfo != null) {
                this.processServerInfo(this.serverInfo, this.peerTrustedKey);
            }
            return new SaltyRTC(this.keyStore, this.host, (int)this.port, this.sslContext, this.peerTrustedKey, this.serverKey, this.tasks, this.pingInterval, SignalingRole.Responder);
        }
        this.requireInitiatorInfo();
        if (this.serverInfo != null) {
            this.processServerInfo(this.serverInfo, this.initiatorPublicKey);
        }
        return new SaltyRTC(this.keyStore, this.host, (int)this.port, this.sslContext, this.initiatorPublicKey, this.authToken, this.serverKey, this.tasks, this.pingInterval);
    }
}

