/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.helpers;

import java.util.List;
import java.util.Map;
import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.signaling.CloseCode;

public class ValidationHelper {
    public static String validateType(Object value, String expected) throws ValidationError {
        if (!(value instanceof String)) {
            throw new ValidationError("Type must be a string");
        }
        String type = (String)value;
        if (!expected.equals(type)) {
            throw new ValidationError("Type must be '" + expected + "'");
        }
        return type;
    }

    public static byte[] validateByteArray(Object value, int expectedLength, String name) throws ValidationError {
        if (!(value instanceof byte[])) {
            throw new ValidationError(name + " must be a byte array");
        }
        byte[] key = (byte[])value;
        if (key.length != expectedLength) {
            throw new ValidationError(name + " must be " + expectedLength + " bytes long, not " + key.length);
        }
        return key;
    }

    public static <T> List<T> validateTypedList(Object values, Class type, String name) throws ValidationError {
        if (!(values instanceof List)) {
            throw new ValidationError(name + " must be a list");
        }
        for (Object element : (List)values) {
            if (type.isInstance(element)) continue;
            throw new ValidationError(name + " must be a " + type.getSimpleName() + " list");
        }
        return (List)values;
    }

    public static Boolean validateBoolean(Object value, String name) throws ValidationError {
        if (!(value instanceof Boolean)) {
            throw new ValidationError(name + " must be a boolean");
        }
        return (Boolean)value;
    }

    @NonNull
    public static Integer validateInteger(Object value, int min, int max, String name) throws ValidationError {
        if (!(value instanceof Integer)) {
            throw new ValidationError(name + " must be an Integer");
        }
        Integer number = (Integer)value;
        if (number < min) {
            throw new ValidationError(name + " must be > " + min);
        }
        if (number > max) {
            throw new ValidationError(name + " must be < " + max);
        }
        return number;
    }

    public static Integer validateInteger(Object value, List<Integer> validRange, String name) throws ValidationError {
        if (!(value instanceof Integer)) {
            throw new ValidationError(name + " must be an Integer");
        }
        Integer number = (Integer)value;
        if (!validRange.contains(number)) {
            throw new ValidationError(name + " is not valid");
        }
        return number;
    }

    public static String validateString(Object value, String name) throws ValidationError {
        if (!(value instanceof String)) {
            throw new ValidationError(name + " must be a String, not " + value.getClass().getName());
        }
        return (String)value;
    }

    public static Integer validateCloseCode(Object value, boolean dropResponder, String name) throws ValidationError {
        int[] codes;
        if (!(value instanceof Integer)) {
            throw new ValidationError(name + " must be an Integer");
        }
        Integer number = (Integer)value;
        for (int code : codes = dropResponder ? CloseCode.CLOSE_CODES_DROP_RESPONDER : CloseCode.CLOSE_CODES_ALL) {
            if (code != number) continue;
            return number;
        }
        throw new ValidationError(name + " must be a valid close code");
    }

    public static Map<String, Object> validateStringObjectMap(Object value, String name) throws ValidationError {
        if (!(value instanceof Map)) {
            throw new ValidationError(name + " must be a Map");
        }
        for (Object element : ((Map)value).keySet()) {
            if (element instanceof String) continue;
            throw new ValidationError(name + " must be a Map with Strings as keys");
        }
        return (Map)value;
    }

    public static Map<String, Map<Object, Object>> validateStringMapMap(Object value, String name) throws ValidationError {
        Map<String, Object> map = ValidationHelper.validateStringObjectMap(value, name);
        for (Object element : map.values()) {
            if (element == null || element instanceof Map) continue;
            throw new ValidationError(name + " must be a Map with Maps or null as values");
        }
        return (Map)value;
    }
}

