/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.keystore;

import java.nio.ByteBuffer;

public class Box {
    private final byte[] nonce;
    private final byte[] data;

    public Box(byte[] nonce, byte[] data) {
        this.nonce = nonce;
        this.data = data;
    }

    public Box(ByteBuffer buffer, int nonceLength) {
        this.nonce = new byte[nonceLength];
        buffer.get(this.nonce, 0, nonceLength);
        this.data = new byte[buffer.remaining()];
        buffer.get(this.data);
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getSize() {
        return this.nonce.length + this.data.length;
    }

    public byte[] toBytes() {
        ByteBuffer box = ByteBuffer.allocate(this.getSize());
        box.put(this.nonce);
        box.put(this.data);
        return box.array();
    }
}

