/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.messages.c2c;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.ValidationHelper;
import org.saltyrtc.client.messages.Message;

public class Application
extends Message {
    public static final String TYPE = "application";
    private Object data;

    public Application(Object data) {
        this.data = data;
    }

    public Application(Map<String, Object> map) throws ValidationError {
        ValidationHelper.validateType(map.get("type"), TYPE);
        if (!map.containsKey("data")) {
            throw new ValidationError("Message is missing the 'data' key");
        }
        this.data = map.get("data");
    }

    public Object getData() {
        return this.data;
    }

    @Override
    public void write(MessagePacker packer) throws IOException {
        packer.packMapHeader(2).packString("type").packString(TYPE).packString("data");
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        packer.writePayload(objectMapper.writeValueAsBytes(this.data));
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

