/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.messages.c2c;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.ValidationHelper;
import org.saltyrtc.client.messages.Message;

public class InitiatorAuth
extends Message {
    public static final String TYPE = "auth";
    private byte[] yourCookie;
    private String task;
    private Map<String, Map<Object, Object>> data;

    public InitiatorAuth(byte[] yourCookie, String task, Map<String, Map<Object, Object>> data) throws ValidationError {
        this.yourCookie = yourCookie;
        this.validateTaskData(task, data);
        this.task = task;
        this.data = data;
    }

    public InitiatorAuth(Map<String, Object> map) throws ValidationError {
        ValidationHelper.validateType(map.get("type"), TYPE);
        int COOKIE_LENGTH = 16;
        this.yourCookie = ValidationHelper.validateByteArray(map.get("your_cookie"), 16, "Cookie");
        this.task = ValidationHelper.validateString(map.get("task"), "task");
        this.data = ValidationHelper.validateStringMapMap(map.get("data"), "data");
        this.validateTaskData(this.task, this.data);
    }

    private void validateTaskData(String task, Map<String, Map<Object, Object>> data) throws ValidationError {
        if (task.isEmpty()) {
            throw new ValidationError("Task name must not be empty");
        }
        if (data.size() < 1) {
            throw new ValidationError("Task data must not be empty");
        }
        if (data.size() > 1) {
            throw new ValidationError("Task data must contain exactly 1 key");
        }
        if (!data.containsKey(task)) {
            throw new ValidationError("Task data must contain an entry for the chosen task");
        }
    }

    public byte[] getYourCookie() {
        return this.yourCookie;
    }

    public String getTask() {
        return this.task;
    }

    public Map<String, Map<Object, Object>> getData() {
        return this.data;
    }

    @Override
    public void write(MessagePacker packer) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        byte[] dataBytes = objectMapper.writeValueAsBytes(this.data);
        packer.packMapHeader(4).packString("type").packString(TYPE).packString("your_cookie").packBinaryHeader(this.yourCookie.length).writePayload(this.yourCookie).packString("task").packString(this.task).packString("data").writePayload(dataBytes);
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

