/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.messages.c2c;

import java.io.IOException;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.ValidationHelper;
import org.saltyrtc.client.messages.Message;

public class Token
extends Message {
    public static final String TYPE = "token";
    private byte[] key;

    public Token(byte[] key) {
        this.key = key;
    }

    public Token(Map<String, Object> map) throws ValidationError {
        ValidationHelper.validateType(map.get("type"), TYPE);
        this.key = ValidationHelper.validateByteArray(map.get("key"), 32, "Key");
    }

    public byte[] getKey() {
        return this.key;
    }

    @Override
    public void write(MessagePacker packer) throws IOException {
        packer.packMapHeader(2).packString("type").packString(TYPE).packString("key").packBinaryHeader(this.key.length).writePayload(this.key);
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

