/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.messages.s2c;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.ValidationHelper;
import org.saltyrtc.client.messages.Message;

public class ClientAuth
extends Message {
    public static final String TYPE = "client-auth";
    @NonNull
    private byte[] yourCookie;
    @Nullable
    private byte[] yourKey = null;
    @NonNull
    private List<String> subprotocols;
    @NonNull
    private int pingInterval;

    public ClientAuth(byte[] yourCookie, List<String> subprotocols, int pingInterval) {
        this.yourCookie = yourCookie;
        this.subprotocols = subprotocols;
        this.pingInterval = pingInterval;
    }

    public ClientAuth(byte[] yourCookie, byte[] yourKey, List<String> subprotocols, int pingInterval) {
        this(yourCookie, subprotocols, pingInterval);
        this.yourKey = yourKey;
    }

    public ClientAuth(Map<String, Object> map) throws ValidationError {
        ValidationHelper.validateType(map.get("type"), TYPE);
        int COOKIE_LENGTH = 16;
        int YOUR_KEY_LENGTH = 32;
        this.yourCookie = ValidationHelper.validateByteArray(map.get("your_cookie"), 16, "your_cookie");
        this.subprotocols = ValidationHelper.validateTypedList(map.get("subprotocols"), String.class, "subprotocols");
        this.pingInterval = ValidationHelper.validateInteger(map.get("ping_interval"), 0, Integer.MAX_VALUE, "ping_interval");
        if (map.containsKey("your_key") && map.get("your_key") != null) {
            this.yourKey = ValidationHelper.validateByteArray(map.get("your_key"), 32, "your_key");
        }
    }

    @NonNull
    public byte[] getYourCookie() {
        return this.yourCookie;
    }

    @Nullable
    public byte[] getYourKey() {
        return this.yourKey;
    }

    @NonNull
    public List<String> getSubprotocols() {
        return this.subprotocols;
    }

    @NonNull
    public int getPingInterval() {
        return this.pingInterval;
    }

    @Override
    public void write(MessagePacker packer) throws IOException {
        boolean hasKey = this.yourKey != null;
        packer.packMapHeader(hasKey ? 5 : 4).packString("type").packString(TYPE).packString("your_cookie").packBinaryHeader(this.yourCookie.length).writePayload(this.yourCookie).packString("ping_interval").packInt(this.pingInterval);
        if (hasKey) {
            packer.packString("your_key").packBinaryHeader(this.yourKey.length).writePayload(this.yourKey);
        }
        packer.packString("subprotocols").packArrayHeader(this.subprotocols.size());
        for (String subprotocol : this.subprotocols) {
            packer.packString(subprotocol);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

