/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.messages.s2c;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.msgpack.core.MessagePacker;
import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.exceptions.ValidationError;
import org.saltyrtc.client.helpers.ValidationHelper;
import org.saltyrtc.client.messages.Message;
import org.saltyrtc.client.signaling.CloseCode;

public class DropResponder
extends Message {
    public static final String TYPE = "drop-responder";
    @NonNull
    private Integer id;
    @Nullable
    private Integer reason;

    public DropResponder(@NonNull Integer id) {
        this.id = id;
    }

    public DropResponder(@NonNull Integer id, @Nullable Integer reason) {
        this(id);
        this.reason = reason;
    }

    public DropResponder(short id) {
        this.id = id;
    }

    public DropResponder(short id, @Nullable Integer reason) {
        this(id);
        this.reason = reason;
    }

    public DropResponder(Map<String, Object> map) throws ValidationError {
        ValidationHelper.validateType(map.get("type"), TYPE);
        this.id = ValidationHelper.validateInteger(map.get("id"), 0, 255, "id");
        if (map.containsKey("reason")) {
            ArrayList<Integer> validRange = new ArrayList<Integer>();
            for (int i = 0; i < CloseCode.CLOSE_CODES_DROP_RESPONDER.length; ++i) {
                validRange.add(CloseCode.CLOSE_CODES_DROP_RESPONDER[i]);
            }
            this.reason = ValidationHelper.validateInteger(map.get("reason"), validRange, "reason");
        }
    }

    @NonNull
    public Integer getId() {
        return this.id;
    }

    @Nullable
    public Integer getReason() {
        return this.reason;
    }

    @Override
    public void write(MessagePacker packer) throws IOException {
        boolean hasReason = this.reason != null;
        packer.packMapHeader(hasReason ? 3 : 2).packString("type").packString(TYPE).packString("id").packInt(this.id.intValue());
        if (hasReason) {
            packer.packString("reason").packInt(this.reason.intValue());
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

