/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.nonce;

import org.saltyrtc.client.cookie.Cookie;

public abstract class Nonce {
    protected byte[] cookie;
    protected int overflow;
    protected long sequence;
    public static final int COOKIE_LENGTH = 16;
    public static final int TOTAL_LENGTH = 24;

    public abstract byte[] toBytes();

    protected void validateCookie(byte[] cookie) {
        if (cookie.length != 16) {
            throw new IllegalArgumentException("cookie must be 16 bytes long");
        }
    }

    protected void validateOverflow(int overflow) {
        if (overflow < 0 || overflow >= 65536) {
            throw new IllegalArgumentException("overflow must be between 0 and 2**16-1");
        }
    }

    protected void validateSequence(long sequence) {
        if (sequence < 0L || sequence >= 0x100000000L) {
            throw new IllegalArgumentException("sequence must be between 0 and 2**32-1");
        }
    }

    public byte[] getCookieBytes() {
        return this.cookie;
    }

    public Cookie getCookie() {
        return new Cookie(this.cookie);
    }

    public int getOverflow() {
        return this.overflow;
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getCombinedSequence() {
        long combined = (long)this.overflow << 32 | this.sequence;
        assert (combined >= 0L && combined < 0x1000000000000L);
        return combined;
    }
}

