/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.signaling;

public class CloseCode {
    public static final int CLOSING_NORMAL = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int NO_SHARED_SUBPROTOCOL = 1002;
    public static final int PATH_FULL = 3000;
    public static final int PROTOCOL_ERROR = 3001;
    public static final int INTERNAL_ERROR = 3002;
    public static final int HANDOVER = 3003;
    public static final int DROPPED_BY_INITIATOR = 3004;
    public static final int INITIATOR_COULD_NOT_DECRYPT = 3005;
    public static final int NO_SHARED_TASK = 3006;
    public static final int INVALID_KEY = 3007;
    public static final int[] CLOSE_CODES_DROP_RESPONDER = new int[]{3001, 3002, 3004, 3005};
    public static final int[] CLOSE_CODES_ALL = new int[]{1001, 1002, 3000, 3001, 3002, 3003, 3004, 3005, 3006, 3007};

    public static String explain(int code) {
        switch (code) {
            case 1000: {
                return "Normal closing";
            }
            case 1001: {
                return "The endpoint is going away";
            }
            case 1002: {
                return "No shared subprotocol could be found";
            }
            case 3000: {
                return "No free responder byte";
            }
            case 3001: {
                return "Protocol error";
            }
            case 3002: {
                return "Internal error";
            }
            case 3003: {
                return "Handover finished";
            }
            case 3004: {
                return "Dropped by initiator";
            }
            case 3005: {
                return "Initiator could not decrypt a message";
            }
            case 3006: {
                return "No shared task was found";
            }
            case 3007: {
                return "Invalid key";
            }
        }
        return "Unknown";
    }
}

