/*
 * Decompiled with CFR 0.152.
 */
package org.saltyrtc.client.signaling.peers;

import org.saltyrtc.client.annotations.NonNull;
import org.saltyrtc.client.annotations.Nullable;
import org.saltyrtc.client.cookie.CookiePair;
import org.saltyrtc.client.nonce.CombinedSequencePair;

public abstract class Peer {
    private short id;
    @Nullable
    byte[] permanentKey;
    @Nullable
    byte[] sessionKey;
    @NonNull
    private final CombinedSequencePair csnPair;
    @NonNull
    private CookiePair cookiePair;

    public Peer(short id) {
        this.id = id;
        this.csnPair = new CombinedSequencePair();
        this.cookiePair = new CookiePair();
    }

    public Peer(short id, @NonNull CookiePair cookiePair) {
        this.id = id;
        this.csnPair = new CombinedSequencePair();
        this.cookiePair = cookiePair;
    }

    public short getId() {
        return this.id;
    }

    @Nullable
    public byte[] getPermanentKey() {
        return this.permanentKey;
    }

    public void setPermanentKey(@Nullable byte[] permanentKey) {
        this.permanentKey = permanentKey;
    }

    public boolean hasPermanentKey() {
        return this.permanentKey != null;
    }

    @Nullable
    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(@Nullable byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    public boolean hasSessionKey() {
        return this.sessionKey != null;
    }

    @NonNull
    public CombinedSequencePair getCsnPair() {
        return this.csnPair;
    }

    @NonNull
    public abstract String getName();

    @NonNull
    public CookiePair getCookiePair() {
        return this.cookiePair;
    }
}

