/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.framework.autoproxy.TargetSourceCreator;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public abstract class AbstractAutoProxyCreator
extends ProxyConfig
implements SmartInstantiationAwareBeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
Ordered,
AopInfrastructureBean {
    protected static final Object[] DO_NOT_PROXY = null;
    protected static final Object[] PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS = new Object[0];
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private boolean freezeProxy = false;
    private String[] interceptorNames = new String[0];
    private boolean applyCommonInterceptorsFirst = true;
    private TargetSourceCreator[] customTargetSourceCreators;
    private ClassLoader proxyClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean classLoaderConfigured = false;
    private BeanFactory beanFactory;
    private final Set<Object> targetSourcedBeans = Collections.synchronizedSet(new HashSet());
    private final Set<Object> earlyProxyReferences = Collections.synchronizedSet(new HashSet());
    private final Set<Object> advisedBeans = Collections.synchronizedSet(new HashSet());
    private final Set<Object> nonAdvisedBeans = Collections.synchronizedSet(new HashSet());
    private final Map<Object, Class> proxyTypes = new ConcurrentHashMap<Object, Class>();

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public void setFrozen(boolean frozen) {
        this.freezeProxy = frozen;
    }

    public boolean isFrozen() {
        return this.freezeProxy;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setCustomTargetSourceCreators(TargetSourceCreator[] targetSourceCreators) {
        this.customTargetSourceCreators = targetSourceCreators;
    }

    public void setInterceptorNames(String[] interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setApplyCommonInterceptorsFirst(boolean applyCommonInterceptorsFirst) {
        this.applyCommonInterceptorsFirst = applyCommonInterceptorsFirst;
    }

    public void setProxyClassLoader(ClassLoader classLoader) {
        this.proxyClassLoader = classLoader;
        this.classLoaderConfigured = classLoader != null;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (!this.classLoaderConfigured) {
            this.proxyClassLoader = classLoader;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Class predictBeanType(Class beanClass, String beanName) {
        Object cacheKey = this.getCacheKey(beanClass, beanName);
        return this.proxyTypes.get(cacheKey);
    }

    public Constructor[] determineCandidateConstructors(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
        Object cacheKey = this.getCacheKey(bean.getClass(), beanName);
        this.earlyProxyReferences.add(cacheKey);
        return this.wrapIfNecessary(bean, beanName, cacheKey);
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        TargetSource targetSource;
        Object cacheKey = this.getCacheKey(beanClass, beanName);
        if (!this.targetSourcedBeans.contains(cacheKey)) {
            if (this.advisedBeans.contains(cacheKey) || this.nonAdvisedBeans.contains(cacheKey)) {
                return null;
            }
            if (this.isInfrastructureClass(beanClass) || this.shouldSkip(beanClass, beanName)) {
                this.nonAdvisedBeans.add(cacheKey);
                return null;
            }
        }
        if ((targetSource = this.getCustomTargetSource(beanClass, beanName)) != null) {
            this.targetSourcedBeans.add(beanName);
            Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(beanClass, beanName, targetSource);
            Object proxy = this.createProxy(beanClass, beanName, specificInterceptors, targetSource);
            this.proxyTypes.put(cacheKey, proxy.getClass());
            return proxy;
        }
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) {
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) {
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object cacheKey;
        if (bean != null && !this.earlyProxyReferences.contains(cacheKey = this.getCacheKey(bean.getClass(), beanName))) {
            return this.wrapIfNecessary(bean, beanName, cacheKey);
        }
        return bean;
    }

    protected Object getCacheKey(Class beanClass, String beanName) {
        return String.valueOf(beanClass.getName()) + "_" + beanName;
    }

    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (this.targetSourcedBeans.contains(beanName)) {
            return bean;
        }
        if (this.nonAdvisedBeans.contains(cacheKey)) {
            return bean;
        }
        if (this.isInfrastructureClass(bean.getClass()) || this.shouldSkip(bean.getClass(), beanName)) {
            this.nonAdvisedBeans.add(cacheKey);
            return bean;
        }
        Object[] specificInterceptors = this.getAdvicesAndAdvisorsForBean(bean.getClass(), beanName, null);
        if (specificInterceptors != DO_NOT_PROXY) {
            this.advisedBeans.add(cacheKey);
            Object proxy = this.createProxy(bean.getClass(), beanName, specificInterceptors, new SingletonTargetSource(bean));
            this.proxyTypes.put(cacheKey, proxy.getClass());
            return proxy;
        }
        this.nonAdvisedBeans.add(cacheKey);
        return bean;
    }

    protected boolean isInfrastructureClass(Class beanClass) {
        boolean retVal;
        boolean bl = retVal = Advisor.class.isAssignableFrom(beanClass) || Advice.class.isAssignableFrom(beanClass) || AopInfrastructureBean.class.isAssignableFrom(beanClass);
        if (retVal && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Did not attempt to auto-proxy infrastructure class [" + beanClass.getName() + "]"));
        }
        return retVal;
    }

    protected boolean shouldSkip(Class beanClass, String beanName) {
        return false;
    }

    protected TargetSource getCustomTargetSource(Class beanClass, String beanName) {
        if (this.customTargetSourceCreators != null && this.beanFactory != null && this.beanFactory.containsBean(beanName)) {
            TargetSourceCreator[] targetSourceCreatorArray = this.customTargetSourceCreators;
            int n = this.customTargetSourceCreators.length;
            int n2 = 0;
            while (n2 < n) {
                TargetSourceCreator tsc = targetSourceCreatorArray[n2];
                TargetSource ts = tsc.getTargetSource(beanClass, beanName);
                if (ts != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("TargetSourceCreator [" + tsc + " found custom TargetSource for bean with name '" + beanName + "'"));
                    }
                    return ts;
                }
                ++n2;
            }
        }
        return null;
    }

    protected Object createProxy(Class beanClass, String beanName, Object[] specificInterceptors, TargetSource targetSource) {
        int n;
        int n2;
        Object[] objectArray;
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        if (!this.shouldProxyTargetClass(beanClass, beanName)) {
            Class[] targetInterfaces = ClassUtils.getAllInterfacesForClass((Class)beanClass, (ClassLoader)this.proxyClassLoader);
            objectArray = targetInterfaces;
            n2 = targetInterfaces.length;
            n = 0;
            while (n < n2) {
                Object targetInterface = objectArray[n];
                proxyFactory.addInterface((Class)targetInterface);
                ++n;
            }
        }
        Advisor[] advisors = this.buildAdvisors(beanName, specificInterceptors);
        objectArray = advisors;
        n2 = advisors.length;
        n = 0;
        while (n < n2) {
            Object advisor = objectArray[n];
            proxyFactory.addAdvisor((Advisor)advisor);
            ++n;
        }
        proxyFactory.setTargetSource(targetSource);
        this.customizeProxyFactory(proxyFactory);
        proxyFactory.setFrozen(this.freezeProxy);
        if (this.advisorsPreFiltered()) {
            proxyFactory.setPreFiltered(true);
        }
        return proxyFactory.getProxy(this.proxyClassLoader);
    }

    protected boolean shouldProxyTargetClass(Class beanClass, String beanName) {
        return this.isProxyTargetClass() || this.beanFactory instanceof ConfigurableListableBeanFactory && AutoProxyUtils.shouldProxyTargetClass((ConfigurableListableBeanFactory)this.beanFactory, beanName);
    }

    protected boolean advisorsPreFiltered() {
        return false;
    }

    protected Advisor[] buildAdvisors(String beanName, Object[] specificInterceptors) {
        Advisor[] commonInterceptors = this.resolveInterceptorNames();
        ArrayList allInterceptors = new ArrayList();
        if (specificInterceptors != null) {
            allInterceptors.addAll(Arrays.asList(specificInterceptors));
            if (commonInterceptors != null) {
                if (this.applyCommonInterceptorsFirst) {
                    allInterceptors.addAll(0, Arrays.asList(commonInterceptors));
                } else {
                    allInterceptors.addAll(Arrays.asList(commonInterceptors));
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            int nrOfCommonInterceptors = commonInterceptors != null ? commonInterceptors.length : 0;
            int nrOfSpecificInterceptors = specificInterceptors != null ? specificInterceptors.length : 0;
            this.logger.debug((Object)("Creating implicit proxy for bean '" + beanName + "' with " + nrOfCommonInterceptors + " common interceptors and " + nrOfSpecificInterceptors + " specific interceptors"));
        }
        Advisor[] advisors = new Advisor[allInterceptors.size()];
        int i = 0;
        while (i < allInterceptors.size()) {
            advisors[i] = this.advisorAdapterRegistry.wrap(allInterceptors.get(i));
            ++i;
        }
        return advisors;
    }

    private Advisor[] resolveInterceptorNames() {
        ConfigurableBeanFactory cbf = this.beanFactory instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)this.beanFactory : null;
        ArrayList<Advisor> advisors = new ArrayList<Advisor>();
        String[] stringArray = this.interceptorNames;
        int n = this.interceptorNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            if (cbf == null || !cbf.isCurrentlyInCreation(beanName)) {
                Object next = this.beanFactory.getBean(beanName);
                advisors.add(this.advisorAdapterRegistry.wrap(next));
            }
            ++n2;
        }
        return advisors.toArray(new Advisor[advisors.size()]);
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
    }

    protected abstract Object[] getAdvicesAndAdvisorsForBean(Class var1, String var2, TargetSource var3) throws BeansException;
}

