/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.core.type.MethodMetadata;

final class ConfigurationClassMethod {
    private final MethodMetadata metadata;
    private final ConfigurationClass declaringClass;

    public ConfigurationClassMethod(MethodMetadata metadata, ConfigurationClass declaringClass) {
        this.metadata = metadata;
        this.declaringClass = declaringClass;
    }

    public MethodMetadata getMetadata() {
        return this.metadata;
    }

    public ConfigurationClass getDeclaringClass() {
        return this.declaringClass;
    }

    public Location getResourceLocation() {
        return new Location(this.declaringClass.getResource(), (Object)this.metadata.getMethodName());
    }

    public void validate(ProblemReporter problemReporter) {
        if (this.declaringClass.getMetadata().hasAnnotation(Configuration.class.getName()) && !this.getMetadata().isOverridable()) {
            problemReporter.error((Problem)new NonOverridableMethodError());
        }
    }

    private class NonOverridableMethodError
    extends Problem {
        public NonOverridableMethodError() {
            super(String.format("Method '%s' must not be private, final or static; change the method's modifiers to continue", ConfigurationClassMethod.this.getMetadata().getMethodName()), ConfigurationClassMethod.this.getResourceLocation());
        }
    }
}

