/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader;
import org.springframework.context.annotation.ConfigurationClassEnhancer;
import org.springframework.context.annotation.ConfigurationClassParser;
import org.springframework.core.Conventions;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

public class ConfigurationClassPostProcessor
implements BeanFactoryPostProcessor,
BeanClassLoaderAware {
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"configurationClass");
    private static final String CONFIGURATION_CLASS_FULL = "full";
    private static final String CONFIGURATION_CLASS_LITE = "lite";
    private static final boolean cglibAvailable = ClassUtils.isPresent((String)"net.sf.cglib.proxy.Enhancer", (ClassLoader)ConfigurationClassPostProcessor.class.getClassLoader());
    private final Log logger = LogFactory.getLog(this.getClass());
    private ProblemReporter problemReporter = new FailFastProblemReporter();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();

    public void setProblemReporter(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
        this.metadataReaderFactory = new CachingMetadataReaderFactory(beanClassLoader);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (!(beanFactory instanceof BeanDefinitionRegistry)) {
            throw new IllegalStateException("ConfigurationClassPostProcessor expects a BeanFactory that implements BeanDefinitionRegistry");
        }
        this.processConfigBeanDefinitions((BeanDefinitionRegistry)beanFactory);
        this.enhanceConfigurationClasses(beanFactory);
    }

    public void processConfigBeanDefinitions(BeanDefinitionRegistry registry) {
        LinkedHashSet<BeanDefinitionHolder> configCandidates = new LinkedHashSet<BeanDefinitionHolder>();
        String[] stringArray = registry.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = registry.getBeanDefinition(beanName);
            if (this.checkConfigurationClassCandidate(beanDef)) {
                configCandidates.add(new BeanDefinitionHolder(beanDef, beanName));
            }
            ++n2;
        }
        if (configCandidates.isEmpty()) {
            return;
        }
        ConfigurationClassParser parser = new ConfigurationClassParser(this.metadataReaderFactory, this.problemReporter);
        for (BeanDefinitionHolder holder : configCandidates) {
            BeanDefinition bd = holder.getBeanDefinition();
            try {
                if (bd instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)bd).hasBeanClass()) {
                    parser.parse(((AbstractBeanDefinition)bd).getBeanClass(), holder.getBeanName());
                    continue;
                }
                parser.parse(bd.getBeanClassName(), holder.getBeanName());
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Failed to load bean class: " + bd.getBeanClassName(), (Throwable)ex);
            }
        }
        parser.validate();
        new ConfigurationClassBeanDefinitionReader(registry).loadBeanDefinitions(parser.getModel());
    }

    protected boolean checkConfigurationClassCandidate(BeanDefinition beanDef) {
        StandardAnnotationMetadata metadata = null;
        if (beanDef instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)beanDef).hasBeanClass()) {
            metadata = new StandardAnnotationMetadata(((AbstractBeanDefinition)beanDef).getBeanClass());
        } else {
            String className = beanDef.getBeanClassName();
            if (className != null) {
                try {
                    MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(className);
                    metadata = metadataReader.getAnnotationMetadata();
                }
                catch (IOException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Could not find class file for introspecting factory methods: " + className), (Throwable)ex);
                    }
                    return false;
                }
            }
        }
        if (metadata != null) {
            if (metadata.hasAnnotation(Configuration.class.getName())) {
                beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, (Object)CONFIGURATION_CLASS_FULL);
                return true;
            }
            if (metadata.hasAnnotation(Component.class.getName())) {
                beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, (Object)CONFIGURATION_CLASS_LITE);
                return true;
            }
        }
        return false;
    }

    public void enhanceConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, AbstractBeanDefinition> configBeanDefs = new LinkedHashMap<String, AbstractBeanDefinition>();
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (CONFIGURATION_CLASS_FULL.equals(beanDef.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE))) {
                if (!(beanDef instanceof AbstractBeanDefinition)) {
                    throw new BeanDefinitionStoreException("Cannot enhance @Configuration bean definition '" + beanName + "' since it is not stored in an AbstractBeanDefinition subclass");
                }
                configBeanDefs.put(beanName, (AbstractBeanDefinition)beanDef);
            }
            ++n2;
        }
        if (configBeanDefs.isEmpty()) {
            return;
        }
        if (!cglibAvailable) {
            throw new IllegalStateException("CGLIB is required to process @Configuration classes. Either add CGLIB to the classpath or remove the following @Configuration bean definitions: " + configBeanDefs.keySet());
        }
        ConfigurationClassEnhancer enhancer = new ConfigurationClassEnhancer((ConfigurableBeanFactory)beanFactory);
        for (Map.Entry entry : configBeanDefs.entrySet()) {
            AbstractBeanDefinition beanDef = (AbstractBeanDefinition)entry.getValue();
            try {
                Class configClass = beanDef.resolveBeanClass(this.beanClassLoader);
                Class enhancedClass = enhancer.enhance(configClass);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("Replacing bean definition '%s' existing class name '%s' with enhanced class name '%s'", entry.getKey(), configClass.getName(), enhancedClass.getName()));
                }
                beanDef.setBeanClass(enhancedClass);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Cannot load configuration class: " + beanDef.getBeanClassName(), ex);
            }
        }
    }
}

