/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericApplicationListenerAdapter
implements SmartApplicationListener {
    private final ApplicationListener delegate;

    public GenericApplicationListenerAdapter(ApplicationListener delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate listener must not be null");
        this.delegate = delegate;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return this.getGenericEventType(this.delegate.getClass()).isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public int getOrder() {
        return this.delegate instanceof Ordered ? ((Ordered)this.delegate).getOrder() : Integer.MAX_VALUE;
    }

    private Class<? extends ApplicationEvent> getGenericEventType(Class<? extends ApplicationListener> currentClass) {
        Class<? extends ApplicationListener> classToIntrospect = currentClass;
        while (classToIntrospect != null) {
            Type[] ifcs;
            Type[] typeArray = ifcs = classToIntrospect.getGenericInterfaces();
            int n = ifcs.length;
            int n2 = 0;
            while (n2 < n) {
                Type ifc = typeArray[n2];
                if (ifc instanceof ParameterizedType) {
                    ParameterizedType paramIfc = (ParameterizedType)ifc;
                    Type rawType = paramIfc.getRawType();
                    if (ApplicationListener.class.equals((Object)rawType)) {
                        Type arg = paramIfc.getActualTypeArguments()[0];
                        if (arg instanceof TypeVariable) {
                            arg = GenericTypeResolver.resolveTypeVariable((TypeVariable)((TypeVariable)arg), this.delegate.getClass());
                        }
                        if (arg instanceof Class) {
                            return (Class)arg;
                        }
                    } else if (ApplicationListener.class.isAssignableFrom((Class)rawType)) {
                        return this.getGenericEventType((Class)rawType);
                    }
                } else if (ApplicationListener.class.isAssignableFrom((Class)ifc)) {
                    return this.getGenericEventType((Class)ifc);
                }
                ++n2;
            }
            classToIntrospect = classToIntrospect.getSuperclass();
        }
        return ApplicationEvent.class;
    }
}

