/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.util.Map;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ast.CommonTypeDescriptors;

public class MapAccessor
implements PropertyAccessor {
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return ((Map)target).containsKey(name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        return new TypedValue(((Map)target).get(name), CommonTypeDescriptors.OBJECT_TYPE_DESCRIPTOR);
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return true;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        ((Map)target).put(name, newValue);
    }

    public Class[] getSpecificTargetClasses() {
        return new Class[]{Map.class};
    }
}

