/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DelegatingExceptionProofRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog(DelegatingExceptionProofRunnable.class);
    private final Runnable delegate;
    private final boolean propagateException;

    public DelegatingExceptionProofRunnable(Runnable delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
        this.propagateException = false;
    }

    public DelegatingExceptionProofRunnable(Runnable delegate, boolean propagateException) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
        this.propagateException = propagateException;
    }

    public final Runnable getDelegate() {
        return this.delegate;
    }

    public void run() {
        block2: {
            try {
                this.delegate.run();
            }
            catch (Throwable ex) {
                logger.error((Object)("Unexpected exception thrown from Runnable: " + this.delegate), ex);
                if (!this.propagateException) break block2;
                ReflectionUtils.rethrowRuntimeException((Throwable)ex);
            }
        }
    }

    public String toString() {
        return "DelegatingExceptionProofRunnable for " + this.delegate;
    }
}

