/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.support.AbstractDelegatingCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentCache<K, V>
extends AbstractDelegatingCache<K, V> {
    private final ConcurrentMap<K, V> store;
    private final String name;

    public ConcurrentCache() {
        this("");
    }

    public ConcurrentCache(String name) {
        this(new ConcurrentHashMap(), name);
    }

    public ConcurrentCache(ConcurrentMap<K, V> delegate, String name) {
        super(delegate, true);
        this.store = delegate;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConcurrentMap<K, V> getNativeCache() {
        return this.store;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.getAllowNullValues() && value == null) {
            ConcurrentMap<K, Object> raw = this.store;
            return (V)this.filterNull(raw.putIfAbsent(key, NULL_HOLDER));
        }
        return this.filterNull(this.store.putIfAbsent(key, value));
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.getAllowNullValues() && value == null) {
            ConcurrentMap<K, V> raw = this.store;
            return raw.remove(key, NULL_HOLDER);
        }
        return this.store.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.getAllowNullValues()) {
            Object rawOldValue = oldValue == null ? NULL_HOLDER : oldValue;
            Object rawNewValue = newValue == null ? NULL_HOLDER : newValue;
            ConcurrentMap<K, Object> raw = this.store;
            return raw.replace(key, rawOldValue, rawNewValue);
        }
        return this.store.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        if (this.getAllowNullValues() && value == null) {
            ConcurrentMap<K, Object> raw = this.store;
            return (V)this.filterNull(raw.replace(key, NULL_HOLDER));
        }
        return this.filterNull(this.store.replace(key, value));
    }
}

