/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.springframework.cache.Cache;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheCache
implements Cache<Object, Object> {
    private final Ehcache cache;

    public EhCacheCache(Ehcache ehcache) {
        Assert.notNull((Object)ehcache, (String)"non null ehcache required");
        Status status = ehcache.getStatus();
        Assert.isTrue((boolean)Status.STATUS_ALIVE.equals(status), (String)("an 'alive' ehcache is required - current cache is " + status.toString()));
        this.cache = ehcache;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    public Ehcache getNativeCache() {
        return this.cache;
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.isKeyInCache(key);
    }

    public boolean containsValue(Object value) {
        return this.cache.isValueInCache(value);
    }

    @Override
    public Object get(Object key) {
        Element element = this.cache.get(key);
        return element != null ? element.getObjectValue() : null;
    }

    @Override
    public Object put(Object key, Object value) {
        Element previous = this.cache.getQuiet(key);
        this.cache.put(new Element(key, value));
        return previous != null ? previous.getValue() : null;
    }

    @Override
    public Object remove(Object key) {
        Object value = null;
        if (this.cache.isKeyInCache(key)) {
            Element element = this.cache.getQuiet(key);
            value = element != null ? element.getObjectValue() : null;
        }
        this.cache.remove(key);
        return value;
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        Element existing = this.cache.getQuiet(key);
        if (existing == null) {
            this.cache.put(new Element(key, value));
            return null;
        }
        return existing.getObjectValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        Element existing = this.cache.getQuiet(key);
        if (existing != null && existing.getObjectValue().equals(value)) {
            this.cache.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public Object replace(Object key, Object value) {
        Element existing = this.cache.getQuiet(key);
        if (existing != null) {
            this.cache.put(new Element(key, value));
            return existing.getObjectValue();
        }
        return null;
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        Element existing = this.cache.getQuiet(key);
        if (existing != null && existing.getObjectValue().equals(oldValue)) {
            this.cache.put(new Element(key, newValue));
            return true;
        }
        return false;
    }
}

