/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.cache.interceptor.CacheDefinition;
import org.springframework.cache.interceptor.CacheDefinitionSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCacheDefinitionSource
implements CacheDefinitionSource,
Serializable {
    private final CacheDefinitionSource[] cacheDefinitionSources;

    public CompositeCacheDefinitionSource(CacheDefinitionSource[] cacheDefinitionSources) {
        Assert.notNull((Object)cacheDefinitionSources, (String)"cacheDefinitionSource array must not be null");
        this.cacheDefinitionSources = cacheDefinitionSources;
    }

    public final CacheDefinitionSource[] getCacheDefinitionSources() {
        return this.cacheDefinitionSources;
    }

    @Override
    public CacheDefinition getCacheDefinition(Method method, Class<?> targetClass) {
        CacheDefinitionSource[] cacheDefinitionSourceArray = this.cacheDefinitionSources;
        int n = this.cacheDefinitionSources.length;
        int n2 = 0;
        while (n2 < n) {
            CacheDefinitionSource source = cacheDefinitionSourceArray[n2];
            CacheDefinition definition = source.getCacheDefinition(method, targetClass);
            if (definition != null) {
                return definition;
            }
            ++n2;
        }
        return null;
    }
}

