/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.DefaultCacheExpressionRootObject;
import org.springframework.cache.interceptor.LazyParamAwareEvaluationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionEvaluator {
    private SpelExpressionParser parser = new SpelExpressionParser();
    private ParameterNameDiscoverer paramNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private Map<Method, Expression> conditionCache = new ConcurrentHashMap<Method, Expression>();
    private Map<Method, Expression> keyCache = new ConcurrentHashMap<Method, Expression>();
    private Map<Method, Method> targetMethodCache = new ConcurrentHashMap<Method, Method>();

    ExpressionEvaluator() {
    }

    EvaluationContext createEvaluationContext(Collection<Cache<?, ?>> caches, Method method, Object[] args, Class<?> targetClass) {
        DefaultCacheExpressionRootObject rootObject = new DefaultCacheExpressionRootObject(caches, method.getName());
        LazyParamAwareEvaluationContext evaluationContext = new LazyParamAwareEvaluationContext(rootObject, this.paramNameDiscoverer, method, args, targetClass, this.targetMethodCache);
        return evaluationContext;
    }

    boolean condition(String conditionExpression, Method method, EvaluationContext evalContext) {
        Expression condExp = this.conditionCache.get(conditionExpression);
        if (condExp == null) {
            condExp = this.parser.parseExpression(conditionExpression);
            this.conditionCache.put(method, condExp);
        }
        return (Boolean)condExp.getValue(evalContext, Boolean.TYPE);
    }

    Object key(String keyExpression, Method method, EvaluationContext evalContext) {
        Expression keyExp = this.keyCache.get(keyExpression);
        if (keyExp == null) {
            keyExp = this.parser.parseExpression(keyExpression);
            this.keyCache.put(method, keyExp);
        }
        return keyExp.getValue(evalContext);
    }
}

