/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.io.Serializable;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegatingCache<K, V>
implements Cache<K, V> {
    public static final Object NULL_HOLDER = new NullHolder();
    private final Map<K, V> delegate;
    private final boolean allowNullValues;

    public <D extends Map<K, V>> AbstractDelegatingCache(D delegate) {
        this(delegate, false);
    }

    public <D extends Map<K, V>> AbstractDelegatingCache(D delegate, boolean allowNullValues) {
        Assert.notNull(delegate);
        this.delegate = delegate;
        this.allowNullValues = allowNullValues;
    }

    public boolean getAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.filterNull(this.delegate.get(key));
    }

    @Override
    public V put(K key, V value) {
        if (this.allowNullValues && value == null) {
            Map<K, Object> map = this.delegate;
            Object val = map.put(key, NULL_HOLDER);
            if (val == NULL_HOLDER) {
                return null;
            }
            return (V)val;
        }
        return this.filterNull(this.delegate.put(key, value));
    }

    @Override
    public V remove(Object key) {
        return this.filterNull(this.delegate.remove(key));
    }

    protected V filterNull(V val) {
        if (this.allowNullValues && val == NULL_HOLDER) {
            return null;
        }
        return val;
    }

    private static class NullHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private NullHolder() {
        }
    }
}

