/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.parsing.ProblemCollector;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ComponentScanExecutor;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.config.AbstractFeatureSpecification;
import org.springframework.context.config.FeatureSpecificationExecutor;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentScanSpec
extends AbstractFeatureSpecification {
    private static final Class<? extends FeatureSpecificationExecutor> EXECUTOR_TYPE = ComponentScanExecutor.class;
    private Boolean includeAnnotationConfig = null;
    private String resourcePattern = null;
    private List<String> basePackages = new ArrayList<String>();
    private Object beanNameGenerator = null;
    private Object scopeMetadataResolver = null;
    private Object scopedProxyMode = null;
    private Boolean useDefaultFilters = null;
    private List<Object> includeFilters = new ArrayList<Object>();
    private List<Object> excludeFilters = new ArrayList<Object>();
    private BeanDefinitionDefaults beanDefinitionDefaults;
    private String[] autowireCandidatePatterns;
    private ClassLoader classLoader;

    ComponentScanSpec() {
        super(EXECUTOR_TYPE);
    }

    public ComponentScanSpec(String ... basePackages) {
        this();
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            this.addBasePackage(basePackage);
            ++n2;
        }
    }

    public ComponentScanSpec(Class<?> ... basePackageClasses) {
        this(ComponentScanSpec.packagesFor(basePackageClasses));
    }

    public ComponentScanSpec includeAnnotationConfig(Boolean includeAnnotationConfig) {
        this.includeAnnotationConfig = includeAnnotationConfig;
        return this;
    }

    ComponentScanSpec includeAnnotationConfig(String includeAnnotationConfig) {
        if (StringUtils.hasText((String)includeAnnotationConfig)) {
            this.includeAnnotationConfig = Boolean.valueOf(includeAnnotationConfig);
        }
        return this;
    }

    Boolean includeAnnotationConfig() {
        return this.includeAnnotationConfig;
    }

    public ComponentScanSpec resourcePattern(String resourcePattern) {
        if (StringUtils.hasText((String)resourcePattern)) {
            this.resourcePattern = resourcePattern;
        }
        return this;
    }

    String resourcePattern() {
        return this.resourcePattern;
    }

    ComponentScanSpec addBasePackage(String basePackage) {
        if (StringUtils.hasText((String)basePackage)) {
            this.basePackages.add(basePackage);
        }
        return this;
    }

    String[] basePackages() {
        return this.basePackages.toArray(new String[this.basePackages.size()]);
    }

    public ComponentScanSpec beanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
        return this;
    }

    ComponentScanSpec beanNameGenerator(String beanNameGenerator, ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        if (StringUtils.hasText((String)beanNameGenerator)) {
            this.beanNameGenerator = beanNameGenerator;
        }
        return this;
    }

    BeanNameGenerator beanNameGenerator() {
        return ComponentScanSpec.nullSafeTypedObject(this.beanNameGenerator, BeanNameGenerator.class);
    }

    public ComponentScanSpec scopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
        return this;
    }

    ComponentScanSpec scopeMetadataResolver(String scopeMetadataResolver, ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        if (StringUtils.hasText((String)scopeMetadataResolver)) {
            this.scopeMetadataResolver = scopeMetadataResolver;
        }
        return this;
    }

    ScopeMetadataResolver scopeMetadataResolver() {
        return ComponentScanSpec.nullSafeTypedObject(this.scopeMetadataResolver, ScopeMetadataResolver.class);
    }

    public ComponentScanSpec scopedProxyMode(ScopedProxyMode scopedProxyMode) {
        this.scopedProxyMode = scopedProxyMode;
        return this;
    }

    ComponentScanSpec scopedProxyMode(String scopedProxyMode) {
        if (StringUtils.hasText((String)scopedProxyMode)) {
            this.scopedProxyMode = scopedProxyMode;
        }
        return this;
    }

    ScopedProxyMode scopedProxyMode() {
        return ComponentScanSpec.nullSafeTypedObject(this.scopedProxyMode, ScopedProxyMode.class);
    }

    public ComponentScanSpec useDefaultFilters(Boolean useDefaultFilters) {
        this.useDefaultFilters = useDefaultFilters;
        return this;
    }

    ComponentScanSpec useDefaultFilters(String useDefaultFilters) {
        if (StringUtils.hasText((String)useDefaultFilters)) {
            this.useDefaultFilters = Boolean.valueOf(useDefaultFilters);
        }
        return this;
    }

    Boolean useDefaultFilters() {
        return this.useDefaultFilters;
    }

    public ComponentScanSpec includeFilters(TypeFilter ... includeFilters) {
        this.includeFilters.clear();
        TypeFilter[] typeFilterArray = includeFilters;
        int n = includeFilters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeFilter filter = typeFilterArray[n2];
            this.addIncludeFilter(filter);
            ++n2;
        }
        return this;
    }

    ComponentScanSpec addIncludeFilter(TypeFilter includeFilter) {
        Assert.notNull((Object)includeFilter, (String)"includeFilter must not be null");
        this.includeFilters.add(includeFilter);
        return this;
    }

    ComponentScanSpec addIncludeFilter(String filterType, String expression, ClassLoader classLoader) {
        this.includeFilters.add(new FilterTypeDescriptor(filterType, expression, classLoader));
        return this;
    }

    TypeFilter[] includeFilters() {
        return this.includeFilters.toArray(new TypeFilter[this.includeFilters.size()]);
    }

    public ComponentScanSpec excludeFilters(TypeFilter ... excludeFilters) {
        this.excludeFilters.clear();
        TypeFilter[] typeFilterArray = excludeFilters;
        int n = excludeFilters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeFilter filter = typeFilterArray[n2];
            this.addExcludeFilter(filter);
            ++n2;
        }
        return this;
    }

    ComponentScanSpec addExcludeFilter(TypeFilter excludeFilter) {
        Assert.notNull((Object)excludeFilter, (String)"excludeFilter must not be null");
        this.excludeFilters.add(excludeFilter);
        return this;
    }

    ComponentScanSpec addExcludeFilter(String filterType, String expression, ClassLoader classLoader) {
        this.excludeFilters.add(new FilterTypeDescriptor(filterType, expression, classLoader));
        return this;
    }

    TypeFilter[] excludeFilters() {
        return this.excludeFilters.toArray(new TypeFilter[this.excludeFilters.size()]);
    }

    ComponentScanSpec beanDefinitionDefaults(BeanDefinitionDefaults beanDefinitionDefaults) {
        this.beanDefinitionDefaults = beanDefinitionDefaults;
        return this;
    }

    BeanDefinitionDefaults beanDefinitionDefaults() {
        return this.beanDefinitionDefaults;
    }

    ComponentScanSpec autowireCandidatePatterns(String[] autowireCandidatePatterns) {
        this.autowireCandidatePatterns = autowireCandidatePatterns;
        return this;
    }

    String[] autowireCandidatePatterns() {
        return this.autowireCandidatePatterns;
    }

    static ComponentScanSpec forDelimitedPackages(String basePackages) {
        Assert.notNull((Object)basePackages, (String)"base packages must not be null");
        return new ComponentScanSpec(StringUtils.tokenizeToStringArray((String)basePackages, (String)",; \t\n"));
    }

    @Override
    public void doValidate(ProblemCollector problems) {
        if (this.basePackages.isEmpty()) {
            problems.error("At least one base package must be specified");
        }
        if (this.beanNameGenerator instanceof String) {
            this.beanNameGenerator = ComponentScanSpec.instantiateUserDefinedType("bean name generator", BeanNameGenerator.class, this.beanNameGenerator, this.classLoader, problems);
        }
        if (this.scopeMetadataResolver instanceof String) {
            this.scopeMetadataResolver = ComponentScanSpec.instantiateUserDefinedType("scope metadata resolver", ScopeMetadataResolver.class, this.scopeMetadataResolver, this.classLoader, problems);
        }
        if (this.scopedProxyMode instanceof String) {
            if ("targetClass".equalsIgnoreCase((String)this.scopedProxyMode)) {
                this.scopedProxyMode = ScopedProxyMode.TARGET_CLASS;
            } else if ("interfaces".equalsIgnoreCase((String)this.scopedProxyMode)) {
                this.scopedProxyMode = ScopedProxyMode.INTERFACES;
            } else if ("no".equalsIgnoreCase((String)this.scopedProxyMode)) {
                this.scopedProxyMode = ScopedProxyMode.NO;
            } else {
                problems.error("invalid scoped proxy mode [%s] supported modes are 'no', 'interfaces' and 'targetClass'");
                this.scopedProxyMode = null;
            }
        }
        if (this.scopeMetadataResolver != null && this.scopedProxyMode != null) {
            problems.error("Cannot define both scope metadata resolver and scoped proxy mode");
        }
        int i = 0;
        while (i < this.includeFilters.size()) {
            if (this.includeFilters.get(i) instanceof FilterTypeDescriptor) {
                this.includeFilters.set(i, ((FilterTypeDescriptor)this.includeFilters.get(i)).createTypeFilter(problems));
            }
            ++i;
        }
        i = 0;
        while (i < this.excludeFilters.size()) {
            if (this.excludeFilters.get(i) instanceof FilterTypeDescriptor) {
                this.excludeFilters.set(i, ((FilterTypeDescriptor)this.excludeFilters.get(i)).createTypeFilter(problems));
            }
            ++i;
        }
    }

    private static Object instantiateUserDefinedType(String description, Class<?> targetType, Object className, ClassLoader classLoader, ProblemCollector problems) {
        Assert.isInstanceOf(String.class, (Object)className, (String)"userType must be of type String");
        Assert.notNull((Object)classLoader, (String)"classLoader must not be null");
        Assert.notNull(targetType, (String)"targetType must not be null");
        Object instance = null;
        try {
            instance = classLoader.loadClass((String)className).newInstance();
            if (!targetType.isAssignableFrom(instance.getClass())) {
                problems.error(String.valueOf(description) + " class name must be assignable to " + targetType.getSimpleName());
                instance = null;
            }
        }
        catch (ClassNotFoundException ex) {
            problems.error(String.format(String.valueOf(description) + " class [%s] not found", className), (Throwable)ex);
        }
        catch (Exception ex) {
            problems.error(String.format("Unable to instantiate %s class [%s] for strategy [%s]. Has a no-argument constructor been provided?", description, className, targetType.getClass().getSimpleName()), (Throwable)ex);
        }
        return instance;
    }

    private void setClassLoader(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"classLoader must not be null");
        if (this.classLoader == null) {
            this.classLoader = classLoader;
        } else {
            Assert.isTrue((this.classLoader == classLoader ? 1 : 0) != 0, (String)"A classLoader has already been assigned and the supplied classLoader is not the same instance. Use the same classLoader for all string-based class properties.");
        }
    }

    private static <T> T nullSafeTypedObject(Object object, Class<T> type) {
        if (object != null && !type.isAssignableFrom(object.getClass())) {
            throw new IllegalStateException(String.format("field must be of type %s but was actually of type %s", type, object.getClass()));
        }
        return (T)object;
    }

    private static String[] packagesFor(Class<?>[] classes) {
        ArrayList<String> packages = new ArrayList<String>();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            packages.add(clazz.getPackage().getName());
            ++n2;
        }
        return packages.toArray(new String[packages.size()]);
    }

    private static class FilterTypeDescriptor {
        private String filterType;
        private String expression;
        private ClassLoader classLoader;

        FilterTypeDescriptor(String filterType, String expression, ClassLoader classLoader) {
            Assert.notNull((Object)filterType, (String)"filterType must not be null");
            Assert.notNull((Object)expression, (String)"expression must not be null");
            Assert.notNull((Object)classLoader, (String)"classLoader must not be null");
            this.filterType = filterType;
            this.expression = expression;
            this.classLoader = classLoader;
        }

        TypeFilter createTypeFilter(ProblemCollector problems) {
            try {
                if ("annotation".equalsIgnoreCase(this.filterType)) {
                    return new AnnotationTypeFilter(this.classLoader.loadClass(this.expression));
                }
                if ("assignable".equalsIgnoreCase(this.filterType) || "assignable_type".equalsIgnoreCase(this.filterType)) {
                    return new AssignableTypeFilter(this.classLoader.loadClass(this.expression));
                }
                if ("aspectj".equalsIgnoreCase(this.filterType)) {
                    return new AspectJTypeFilter(this.expression, this.classLoader);
                }
                if ("regex".equalsIgnoreCase(this.filterType)) {
                    return new RegexPatternTypeFilter(Pattern.compile(this.expression));
                }
                if ("custom".equalsIgnoreCase(this.filterType)) {
                    Class<?> filterClass = this.classLoader.loadClass(this.expression);
                    if (!TypeFilter.class.isAssignableFrom(filterClass)) {
                        problems.error(String.format("custom type filter class [%s] must be assignable to %s", this.expression, TypeFilter.class));
                    }
                    return (TypeFilter)BeanUtils.instantiateClass(filterClass);
                }
                problems.error(String.format("Unsupported filter type [%s]; supported types are: 'annotation', 'assignable[_type]', 'aspectj', 'regex', 'custom'", this.filterType));
            }
            catch (ClassNotFoundException ex) {
                problems.error("Type filter class not found: " + this.expression, (Throwable)ex);
            }
            catch (Exception ex) {
                problems.error(ex.getMessage(), ex.getCause());
            }
            return new PlaceholderTypeFilter();
        }

        private class PlaceholderTypeFilter
        implements TypeFilter {
            private PlaceholderTypeFilter() {
            }

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                throw new UnsupportedOperationException(String.format("match() method for placeholder type filter for {filterType=%s,expression=%s} should never be invoked", FilterTypeDescriptor.this.filterType, FilterTypeDescriptor.this.expression));
            }
        }
    }
}

