/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.springframework.beans.factory.parsing.PassThroughSourceExtractor;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.BeanAnnotationHelper;
import org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader;
import org.springframework.context.annotation.ConfigurationClassEnhancer;
import org.springframework.context.annotation.ConfigurationClassParser;
import org.springframework.context.annotation.EarlyBeanReferenceProxyCreator;
import org.springframework.context.annotation.Feature;
import org.springframework.context.annotation.FeatureConfiguration;
import org.springframework.context.annotation.FeatureMethodExecutionException;
import org.springframework.context.annotation.SimpleComponentRegistrar;
import org.springframework.context.config.FeatureSpecification;
import org.springframework.context.config.SourceAwareSpecification;
import org.springframework.context.config.SpecificationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationClassPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ResourceLoaderAware,
BeanClassLoaderAware,
EnvironmentAware {
    private static final boolean cglibAvailable = ClassUtils.isPresent((String)"net.sf.cglib.proxy.Enhancer", (ClassLoader)ConfigurationClassPostProcessor.class.getClassLoader());
    private final Log logger = LogFactory.getLog(this.getClass());
    private SourceExtractor sourceExtractor = new PassThroughSourceExtractor();
    private ProblemReporter problemReporter = new FailFastProblemReporter();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
    private boolean setMetadataReaderFactoryCalled = false;
    private boolean postProcessBeanDefinitionRegistryCalled = false;
    private boolean postProcessBeanFactoryCalled = false;
    private Environment environment;
    private ConfigurationClassBeanDefinitionReader reader;

    public void setSourceExtractor(SourceExtractor sourceExtractor) {
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new PassThroughSourceExtractor();
    }

    public void setProblemReporter(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter != null ? problemReporter : new FailFastProblemReporter();
    }

    public void setMetadataReaderFactory(MetadataReaderFactory metadataReaderFactory) {
        Assert.notNull((Object)metadataReaderFactory, (String)"MetadataReaderFactory must not be null");
        this.metadataReaderFactory = metadataReaderFactory;
        this.setMetadataReaderFactoryCalled = true;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
        if (!this.setMetadataReaderFactoryCalled) {
            this.metadataReaderFactory = new CachingMetadataReaderFactory(beanClassLoader);
        }
    }

    @Override
    public void setEnvironment(Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        this.environment = environment;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        if (this.postProcessBeanDefinitionRegistryCalled) {
            throw new IllegalStateException("postProcessBeanDefinitionRegistry already called for this post-processor");
        }
        if (this.postProcessBeanFactoryCalled) {
            throw new IllegalStateException("postProcessBeanFactory already called for this post-processor");
        }
        this.postProcessBeanDefinitionRegistryCalled = true;
        this.processConfigurationClasses(registry);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.postProcessBeanFactoryCalled) {
            throw new IllegalStateException("postProcessBeanFactory already called for this post-processor");
        }
        this.postProcessBeanFactoryCalled = true;
        if (!this.postProcessBeanDefinitionRegistryCalled) {
            this.processConfigurationClasses((BeanDefinitionRegistry)beanFactory);
        }
    }

    private void processConfigurationClasses(BeanDefinitionRegistry registry) {
        ConfigurationClassBeanDefinitionReader reader = this.getConfigurationClassBeanDefinitionReader(registry);
        this.processConfigBeanDefinitions(registry, reader);
        this.enhanceConfigurationClasses((ConfigurableListableBeanFactory)registry);
        this.processFeatureConfigurationClasses((ConfigurableListableBeanFactory)registry);
    }

    private void processFeatureConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        Map<String, Object> featureConfigBeans = this.retrieveFeatureConfigurationBeans(beanFactory);
        if (featureConfigBeans.size() == 0) {
            return;
        }
        for (Object featureConfigBean : featureConfigBeans.values()) {
            this.checkForBeanMethods(featureConfigBean.getClass());
        }
        if (!cglibAvailable) {
            throw new IllegalStateException("CGLIB is required to process @FeatureConfiguration classes. Either add CGLIB to the classpath or remove the following @FeatureConfiguration bean definitions: " + featureConfigBeans.keySet());
        }
        final EarlyBeanReferenceProxyCreator proxyCreator = new EarlyBeanReferenceProxyCreator((AutowireCapableBeanFactory)beanFactory);
        final SpecificationContext specificationContext = this.createSpecificationContext(beanFactory);
        for (final Object featureConfigBean : featureConfigBeans.values()) {
            ReflectionUtils.doWithMethods(featureConfigBean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method featureMethod) throws IllegalArgumentException, IllegalAccessException {
                    ConfigurationClassPostProcessor.this.processFeatureMethod(featureMethod, featureConfigBean, specificationContext, proxyCreator);
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method candidateMethod) {
                    return candidateMethod.isAnnotationPresent(Feature.class);
                }
            });
        }
    }

    private Map<String, Object> retrieveFeatureConfigurationBeans(ConfigurableListableBeanFactory beanFactory) {
        HashMap<String, Object> fcBeans = new HashMap<String, Object>();
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (this.isFeatureConfiguration(beanDef)) {
                fcBeans.put(beanName, beanFactory.getBean(beanName));
            }
            ++n2;
        }
        return fcBeans;
    }

    private boolean isFeatureConfiguration(BeanDefinition candidate) {
        if (!(candidate instanceof AbstractBeanDefinition) || candidate.getBeanClassName() == null) {
            return false;
        }
        AbstractBeanDefinition beanDef = (AbstractBeanDefinition)candidate;
        if (beanDef.hasBeanClass()) {
            Class beanClass = beanDef.getBeanClass();
            if (AnnotationUtils.findAnnotation((Class)beanClass, FeatureConfiguration.class) != null) {
                return true;
            }
        } else {
            String className = null;
            try {
                className = beanDef.getBeanClassName();
                MetadataReader metadataReader = new SimpleMetadataReaderFactory().getMetadataReader(className);
                AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
                if (annotationMetadata.isAnnotated(FeatureConfiguration.class.getName())) {
                    return true;
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not create MetadataReader for class " + className, ex);
            }
        }
        return false;
    }

    private void checkForBeanMethods(Class<?> featureConfigClass) {
        ReflectionUtils.doWithMethods(featureConfigClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method beanMethod) throws IllegalArgumentException, IllegalAccessException {
                throw new FeatureMethodExecutionException(String.format("@FeatureConfiguration classes must not contain @Bean-annotated methods. %s.%s() is annotated with @Bean and must be removed in order to proceed. Consider moving this method into a dedicated @Configuration class and injecting the bean as a parameter into any @Feature method(s) that need it.", beanMethod.getDeclaringClass().getSimpleName(), beanMethod.getName()));
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method candidateMethod) {
                return BeanAnnotationHelper.isBeanAnnotated(candidateMethod);
            }
        });
    }

    private void processFeatureMethod(Method featureMethod, Object configInstance, SpecificationContext specificationContext, EarlyBeanReferenceProxyCreator proxyCreator) {
        try {
            if (!FeatureSpecification.class.isAssignableFrom(featureMethod.getReturnType())) {
                throw new IllegalArgumentException(String.format("Return type for @Feature method %s.%s() must be assignable to FeatureSpecification", featureMethod.getDeclaringClass().getSimpleName(), featureMethod.getName()));
            }
            ArrayList<Object> beanArgs = new ArrayList<Object>();
            Class<?>[] parameterTypes = featureMethod.getParameterTypes();
            int i = 0;
            while (i < parameterTypes.length) {
                MethodParameter mp = new MethodParameter(featureMethod, i);
                DependencyDescriptor dd = new DependencyDescriptor(mp, true, false);
                Object proxiedBean = proxyCreator.createProxy(dd);
                beanArgs.add(proxiedBean);
                ++i;
            }
            featureMethod.setAccessible(true);
            FeatureSpecification spec = (FeatureSpecification)featureMethod.invoke(configInstance, beanArgs.toArray(new Object[beanArgs.size()]));
            Assert.notNull((Object)spec, (String)String.format("The specification returned from @Feature method %s.%s() must not be null", featureMethod.getDeclaringClass().getSimpleName(), featureMethod.getName()));
            if (spec instanceof SourceAwareSpecification) {
                ((SourceAwareSpecification)spec).source(featureMethod);
                ((SourceAwareSpecification)spec).sourceName(featureMethod.getName());
            }
            spec.execute(specificationContext);
        }
        catch (Exception ex) {
            throw new FeatureMethodExecutionException(ex);
        }
    }

    private SpecificationContext createSpecificationContext(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        SpecificationContext specificationContext = new SpecificationContext();
        specificationContext.setEnvironment(this.environment);
        specificationContext.setResourceLoader(this.resourceLoader);
        specificationContext.setRegistry(registry);
        specificationContext.setRegistrar(new SimpleComponentRegistrar(registry));
        specificationContext.setProblemReporter(this.problemReporter);
        return specificationContext;
    }

    private ConfigurationClassBeanDefinitionReader getConfigurationClassBeanDefinitionReader(BeanDefinitionRegistry registry) {
        if (this.reader == null) {
            this.reader = new ConfigurationClassBeanDefinitionReader(registry, this.sourceExtractor, this.problemReporter, this.metadataReaderFactory, this.resourceLoader, this.environment);
        }
        return this.reader;
    }

    public void processConfigBeanDefinitions(BeanDefinitionRegistry registry, ConfigurationClassBeanDefinitionReader reader) {
        LinkedHashSet<BeanDefinitionHolder> configCandidates = new LinkedHashSet<BeanDefinitionHolder>();
        String[] stringArray = registry.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = registry.getBeanDefinition(beanName);
            if (ConfigurationClassBeanDefinitionReader.checkConfigurationClassCandidate(beanDef, this.metadataReaderFactory)) {
                configCandidates.add(new BeanDefinitionHolder(beanDef, beanName));
            }
            ++n2;
        }
        if (configCandidates.isEmpty()) {
            return;
        }
        ConfigurationClassParser parser = new ConfigurationClassParser(this.metadataReaderFactory, this.problemReporter, this.environment);
        for (BeanDefinitionHolder holder : configCandidates) {
            BeanDefinition bd = holder.getBeanDefinition();
            try {
                if (bd instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)bd).hasBeanClass()) {
                    parser.parse(((AbstractBeanDefinition)bd).getBeanClass(), holder.getBeanName());
                    continue;
                }
                parser.parse(bd.getBeanClassName(), holder.getBeanName());
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Failed to load bean class: " + bd.getBeanClassName(), (Throwable)ex);
            }
        }
        parser.validate();
        reader.loadBeanDefinitions(parser.getConfigurationClasses());
    }

    public void enhanceConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, AbstractBeanDefinition> configBeanDefs = new LinkedHashMap<String, AbstractBeanDefinition>();
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (ConfigurationClassBeanDefinitionReader.isFullConfigurationClass(beanDef)) {
                if (!(beanDef instanceof AbstractBeanDefinition)) {
                    throw new BeanDefinitionStoreException("Cannot enhance @Configuration bean definition '" + beanName + "' since it is not stored in an AbstractBeanDefinition subclass");
                }
                configBeanDefs.put(beanName, (AbstractBeanDefinition)beanDef);
            }
            ++n2;
        }
        if (configBeanDefs.isEmpty()) {
            return;
        }
        if (!cglibAvailable) {
            throw new IllegalStateException("CGLIB is required to process @Configuration classes. Either add CGLIB to the classpath or remove the following @Configuration bean definitions: " + configBeanDefs.keySet());
        }
        ConfigurationClassEnhancer enhancer = new ConfigurationClassEnhancer((ConfigurableBeanFactory)beanFactory);
        for (Map.Entry entry : configBeanDefs.entrySet()) {
            AbstractBeanDefinition beanDef = (AbstractBeanDefinition)entry.getValue();
            try {
                Class configClass = beanDef.resolveBeanClass(this.beanClassLoader);
                Class<?> enhancedClass = enhancer.enhance(configClass);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)String.format("Replacing bean definition '%s' existing class name '%s' with enhanced class name '%s'", entry.getKey(), configClass.getName(), enhancedClass.getName()));
                }
                beanDef.setBeanClass(enhancedClass);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Cannot load configuration class: " + beanDef.getBeanClassName(), ex);
            }
        }
    }
}

